/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;
import java.util.Collection;

public class ConvexHullShapeSettings
extends ConvexShapeSettings {
    private static final int numAxes = 3;

    public ConvexHullShapeSettings(Collection<?> points) {
        this(points, 0.05f);
    }

    public ConvexHullShapeSettings(Collection<?> points, float maxConvexRadius) {
        this(points, maxConvexRadius, null);
    }

    public ConvexHullShapeSettings(Collection<?> points, float maxConvexRadius, ConstPhysicsMaterial material) {
        long settingsVa;
        int numPoints = points.size();
        if (numPoints == 0) {
            settingsVa = ConvexHullShapeSettings.createDefault();
        } else {
            int numFloats = 3 * numPoints;
            FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
            for (Object element : points) {
                Vec3Arg point = (Vec3Arg)element;
                point.put(buffer);
            }
            long materialVa = material == null ? 0L : material.targetVa();
            settingsVa = ConvexHullShapeSettings.createSettings(numPoints, buffer, maxConvexRadius, materialVa);
        }
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.ConvexHull);
    }

    public ConvexHullShapeSettings(ConvexHullShapeSettings original) {
        long originalVa = original.va();
        long copyVa = ConvexHullShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.ConvexHull);
    }

    public ConvexHullShapeSettings(int numPoints, FloatBuffer points) {
        this(numPoints, points, 0.05f);
    }

    public ConvexHullShapeSettings(int numPoints, FloatBuffer points, float maxConvexRadius) {
        this(numPoints, points, maxConvexRadius, null);
    }

    public ConvexHullShapeSettings(int numPoints, FloatBuffer points, float maxConvexRadius, ConstPhysicsMaterial material) {
        assert (points.isDirect());
        long materialVa = material == null ? 0L : material.targetVa();
        long settingsVa = ConvexHullShapeSettings.createSettings(numPoints, points, maxConvexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.ConvexHull);
    }

    ConvexHullShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.ConvexHull);
    }

    public ConvexHullShapeSettings(Vec3Arg ... points) {
        long settingsVa;
        int numPoints = points.length;
        if (points.length == 0) {
            settingsVa = ConvexHullShapeSettings.createDefault();
        } else {
            int numFloats = 3 * numPoints;
            FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
            for (Vec3Arg point : points) {
                point.put(buffer);
            }
            settingsVa = ConvexHullShapeSettings.createSettings(numPoints, buffer, 0.05f, 0L);
        }
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.ConvexHull);
    }

    public ConvexHullShapeSettings(Vec3Arg[] points, float maxConvexRadius) {
        this(points, maxConvexRadius, null);
    }

    public ConvexHullShapeSettings(Vec3Arg[] points, float maxConvexRadius, ConstPhysicsMaterial material) {
        int numPoints = points.length;
        int numFloats = 3 * numPoints;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Vec3Arg point : points) {
            point.put(buffer);
        }
        long materialVa = material == null ? 0L : material.targetVa();
        long settingsVa = ConvexHullShapeSettings.createSettings(numPoints, buffer, maxConvexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.ConvexHull);
    }

    public int countPoints() {
        long settingsVa = this.va();
        int result = ConvexHullShapeSettings.countPoints(settingsVa);
        return result;
    }

    public float getHullTolerance() {
        long settingsVa = this.va();
        float result = ConvexHullShapeSettings.getHullTolerance(settingsVa);
        return result;
    }

    public float getMaxConvexRadius() {
        long settingsVa = this.va();
        float result = ConvexHullShapeSettings.getMaxConvexRadius(settingsVa);
        return result;
    }

    public float getMaxErrorConvexRadius() {
        long settingsVa = this.va();
        float result = ConvexHullShapeSettings.getMaxErrorConvexRadius(settingsVa);
        return result;
    }

    public void setHullTolerance(float tolerance) {
        long settingsVa = this.va();
        ConvexHullShapeSettings.setHullTolerance(settingsVa, tolerance);
    }

    public void setMaxConvexRadius(float radius) {
        long settingsVa = this.va();
        ConvexHullShapeSettings.setMaxConvexRadius(settingsVa, radius);
    }

    public void setMaxErrorConvexRadius(float maxError) {
        long settingsVa = this.va();
        ConvexHullShapeSettings.setMaxErrorConvexRadius(settingsVa, maxError);
    }

    public void setPoints(Vec3Arg ... points) {
        int numPoints = points.length;
        int numFloats = 3 * numPoints;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Vec3Arg point : points) {
            point.put(buffer);
        }
        long settingsVa = this.va();
        ConvexHullShapeSettings.setPoints(settingsVa, numPoints, buffer);
    }

    private static native int countPoints(long var0);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createSettings(int var0, FloatBuffer var1, float var2, long var3);

    private static native float getHullTolerance(long var0);

    private static native float getMaxConvexRadius(long var0);

    private static native float getMaxErrorConvexRadius(long var0);

    private static native void setHullTolerance(long var0, float var2);

    private static native void setMaxConvexRadius(long var0, float var2);

    private static native void setMaxErrorConvexRadius(long var0, float var2);

    private static native void setPoints(long var0, int var2, FloatBuffer var3);
}

