/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.GeometryRef;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Lod;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstLod;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import com.github.stephengold.joltjni.template.RefTarget;

public class Geometry
extends JoltPhysicsObject
implements RefTarget {
    public Geometry(ConstAaBox bounds) {
        long boundsVa = bounds.targetVa();
        long geometryVa = Geometry.create(boundsVa);
        long refVa = Geometry.toRef(geometryVa);
        Runnable freeingAction = () -> GeometryRef.free(refVa);
        this.setVirtualAddress(geometryVa, freeingAction);
    }

    Geometry(long geometryVa) {
        long refVa = Geometry.toRef(geometryVa);
        Runnable freeingAction = () -> GeometryRef.free(refVa);
        this.setVirtualAddress(geometryVa, freeingAction);
    }

    public int countLods() {
        long geometryVa = this.va();
        int result = Geometry.countLods(geometryVa);
        return result;
    }

    public ConstAaBox getBounds() {
        long geometryVa = this.va();
        long resultVa = Geometry.getBounds(geometryVa);
        AaBox result = new AaBox(this, resultVa);
        return result;
    }

    public ConstLod getLod(int index) {
        long geometryVa = this.va();
        long resultVa = Geometry.getLodFromIndex(geometryVa, index);
        Lod result = new Lod(this, resultVa);
        return result;
    }

    public ConstLod getLod(Vec3Arg cameraPosition, ConstAaBox worldSpaceBounds, float lodScaleSq) {
        long geometryVa = this.va();
        float camX = cameraPosition.getX();
        float camY = cameraPosition.getY();
        float camZ = cameraPosition.getZ();
        long boundsVa = worldSpaceBounds.targetVa();
        long resultVa = Geometry.getLodForCamera(geometryVa, camX, camY, camZ, boundsVa, lodScaleSq);
        Lod result = new Lod(this, resultVa);
        return result;
    }

    public ConstLod[] getLods() {
        long geometryVa = this.va();
        int numLods = Geometry.countLods(geometryVa);
        ConstLod[] result = new Lod[numLods];
        for (int index = 0; index < numLods; ++index) {
            long levelVa = Geometry.getLodFromIndex(geometryVa, index);
            result[index] = new Lod(this, levelVa);
        }
        return result;
    }

    @Override
    public int getRefCount() {
        long geometryVa = this.va();
        int result = Geometry.getRefCount(geometryVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long geometryVa = this.va();
        Geometry.setEmbedded(geometryVa);
    }

    @Override
    public Ref toRef() {
        long geometryVa = this.va();
        long refVa = Geometry.toRef(geometryVa);
        GeometryRef result = new GeometryRef(refVa, true);
        return result;
    }

    private static native int countLods(long var0);

    private static native long create(long var0);

    private static native long getBounds(long var0);

    private static native long getLodFromIndex(long var0, int var2);

    private static native long getLodForCamera(long var0, float var2, float var3, float var4, long var5, float var7);

    private static native int getRefCount(long var0);

    private static native void setEmbedded(long var0);

    private static native long toRef(long var0);
}

