/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.GroupFilterTable;
import com.github.stephengold.joltjni.template.Ref;

public final class GroupFilterTableRef
extends Ref {
    public GroupFilterTableRef() {
        long refVa = GroupFilterTableRef.createDefault();
        this.setVirtualAddress(refVa, () -> GroupFilterTableRef.free(refVa));
    }

    GroupFilterTableRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> GroupFilterTableRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void disableCollision(int subGroup1, int subGroup2) {
        long filterVa = this.targetVa();
        GroupFilterTable.disableCollision(filterVa, subGroup1, subGroup2);
    }

    public void enableCollision(int subGroup1, int subGroup2) {
        long filterVa = this.targetVa();
        GroupFilterTable.enableCollision(filterVa, subGroup1, subGroup2);
    }

    @Override
    public GroupFilterTable getPtr() {
        long filterVa = this.targetVa();
        GroupFilterTable result = new GroupFilterTable(filterVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = GroupFilterTableRef.getPtr(refVa);
        return result;
    }

    @Override
    public GroupFilterTableRef toRef() {
        long refVa = this.va();
        long copyVa = GroupFilterTableRef.copy(refVa);
        GroupFilterTableRef result = new GroupFilterTableRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

