/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.IndexedTriangle;
import com.github.stephengold.joltjni.IndexedTriangleList;
import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.PhysicsMaterialList;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstTriangle;
import com.github.stephengold.joltjni.readonly.ConstVertexList;
import java.nio.FloatBuffer;
import java.util.List;

public class MeshShapeSettings
extends ShapeSettings {
    public MeshShapeSettings() {
        long settingsVa = MeshShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(Float3[] vertices, IndexedTriangleList indices) {
        int numVertices = vertices.length;
        int numFloats = 3 * numVertices;
        FloatBuffer vBuffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Float3 vertex : vertices) {
            vertex.put(vBuffer);
        }
        long indicesVa = indices.va();
        long settingsVa = MeshShapeSettings.createMeshShapeSettings(numVertices, vBuffer, indicesVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(Float3[] vertexArray, IndexedTriangle ... itArray) {
        int numVertices = vertexArray.length;
        int numFloats = 3 * numVertices;
        FloatBuffer vBuffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Float3 vertex : vertexArray) {
            vertex.put(vBuffer);
        }
        IndexedTriangleList itList = new IndexedTriangleList();
        for (IndexedTriangle triangle : itArray) {
            itList.pushBack(triangle);
        }
        long indicesVa = itList.va();
        long settingsVa = MeshShapeSettings.createMeshShapeSettings(numVertices, vBuffer, indicesVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(FloatBuffer positionBuffer) {
        int numFloats = positionBuffer.capacity();
        assert (numFloats % 9 == 0) : "numFloats = " + numFloats;
        int numVertices = numFloats / 3;
        int numTriangles = numVertices / 3;
        long settingsVa = MeshShapeSettings.createFromTrianglesNoMats(numTriangles, positionBuffer);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    MeshShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(MeshShapeSettings original) {
        long originalVa = original.va();
        long copyVa = MeshShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(List<Float3> vertices, IndexedTriangleList indices) {
        int numVertices = vertices.size();
        int numFloats = 3 * numVertices;
        FloatBuffer vBuffer = Jolt.newDirectFloatBuffer(numFloats);
        for (Float3 vertex : vertices) {
            vertex.put(vBuffer);
        }
        long indicesVa = indices.va();
        long settingsVa = MeshShapeSettings.createMeshShapeSettings(numVertices, vBuffer, indicesVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(List<? extends ConstTriangle> triangleList) {
        int numTriangles = triangleList.size();
        int numVertices = 3 * numTriangles;
        int numFloats = 3 * numVertices;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (ConstTriangle constTriangle : triangleList) {
            constTriangle.putVertices(buffer);
        }
        long settingsVa = MeshShapeSettings.createFromTrianglesNoMats(numTriangles, buffer);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(List<? extends ConstTriangle> triangleList, PhysicsMaterialList materials) {
        int numTriangles = triangleList.size();
        int numVertices = 3 * numTriangles;
        int numFloats = 3 * numVertices;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (ConstTriangle constTriangle : triangleList) {
            constTriangle.putVertices(buffer);
        }
        long materialsVa = materials.va();
        long settingsVa = MeshShapeSettings.createSettingsFromTriangles(numTriangles, buffer, materialsVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(ConstVertexList vertices, IndexedTriangleList indices) {
        int numVertices = vertices.size();
        FloatBuffer buffer = vertices.toDirectBuffer();
        long indicesVa = indices.va();
        long settingsVa = MeshShapeSettings.createMeshShapeSettings(numVertices, buffer, indicesVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(ConstTriangle ... triangleArray) {
        int numTriangles = triangleArray.length;
        int numVertices = 3 * numTriangles;
        int numFloats = 3 * numVertices;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (ConstTriangle triangle : triangleArray) {
            triangle.putVertices(buffer);
        }
        long settingsVa = MeshShapeSettings.createFromTrianglesNoMats(numTriangles, buffer);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public MeshShapeSettings(ConstTriangle[] triangleArray, PhysicsMaterialList materials) {
        int numTriangles = triangleArray.length;
        int numVertices = 3 * numTriangles;
        int numFloats = 3 * numVertices;
        FloatBuffer buffer = Jolt.newDirectFloatBuffer(numFloats);
        for (ConstTriangle triangle : triangleArray) {
            triangle.putVertices(buffer);
        }
        long materialsVa = materials.va();
        long settingsVa = MeshShapeSettings.createSettingsFromTriangles(numTriangles, buffer, materialsVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Mesh);
    }

    public void addIndexedTriangle(int vi0, int vi1, int vi2) {
        long settingsVa = this.va();
        MeshShapeSettings.addIndexedTriangle(settingsVa, vi0, vi1, vi2);
    }

    public void addTriangleVertex(Float3 vertex) {
        long settingsVa = this.va();
        MeshShapeSettings.addTriangleVertex(settingsVa, vertex.x, vertex.y, vertex.z);
    }

    public int countTriangles() {
        long settingsVa = this.va();
        int result = MeshShapeSettings.countTriangles(settingsVa);
        return result;
    }

    public int countTriangleVertices() {
        long settingsVa = this.va();
        int result = MeshShapeSettings.countTriangleVertices(settingsVa);
        return result;
    }

    public float getActiveEdgeCosThresholdAngle() {
        long settingsVa = this.va();
        float result = MeshShapeSettings.getActiveEdgeCosThresholdAngle(settingsVa);
        return result;
    }

    public int getMaxTrianglesPerLeaf() {
        long settingsVa = this.va();
        int result = MeshShapeSettings.getMaxTrianglesPerLeaf(settingsVa);
        return result;
    }

    public boolean getPerTriangleUserData() {
        long settingsVa = this.va();
        boolean result = MeshShapeSettings.getPerTriangleUserData(settingsVa);
        return result;
    }

    public void reserveIndexedTriangles(int numTriangles) {
        long settingsVa = this.va();
        MeshShapeSettings.reserveIndexedTriangles(settingsVa, numTriangles);
    }

    public void reserveTriangleVertices(int numVertices) {
        long settingsVa = this.va();
        MeshShapeSettings.reserveTriangleVertices(settingsVa, numVertices);
    }

    public void setActiveEdgeCosThresholdAngle(float cosine) {
        long settingsVa = this.va();
        MeshShapeSettings.setActiveEdgeCosThresholdAngle(settingsVa, cosine);
    }

    public void setMaxTrianglesPerLeaf(int numTriangles) {
        long settingsVa = this.va();
        MeshShapeSettings.setMaxTrianglesPerLeaf(settingsVa, numTriangles);
    }

    public void setPerTriangleUserData(boolean include) {
        long settingsVa = this.va();
        MeshShapeSettings.setPerTriangleUserData(settingsVa, include);
    }

    private static native void addIndexedTriangle(long var0, int var2, int var3, int var4);

    private static native void addTriangleVertex(long var0, float var2, float var3, float var4);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createFromTrianglesNoMats(int var0, FloatBuffer var1);

    private static native long createMeshShapeSettings(int var0, FloatBuffer var1, long var2);

    private static native long createSettingsFromTriangles(int var0, FloatBuffer var1, long var2);

    private static native int countTriangles(long var0);

    private static native int countTriangleVertices(long var0);

    private static native float getActiveEdgeCosThresholdAngle(long var0);

    private static native int getMaxTrianglesPerLeaf(long var0);

    private static native boolean getPerTriangleUserData(long var0);

    private static native void reserveIndexedTriangles(long var0, int var2);

    private static native void reserveTriangleVertices(long var0, int var2);

    private static native void setActiveEdgeCosThresholdAngle(long var0, float var2);

    private static native void setMaxTrianglesPerLeaf(long var0, int var2);

    private static native void setPerTriangleUserData(long var0, boolean var2);
}

