/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyFilter;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.CastRayCollector;
import com.github.stephengold.joltjni.CastShapeCollector;
import com.github.stephengold.joltjni.CollidePointCollector;
import com.github.stephengold.joltjni.CollideShapeCollector;
import com.github.stephengold.joltjni.CollideShapeSettings;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.RRayCast;
import com.github.stephengold.joltjni.RShapeCast;
import com.github.stephengold.joltjni.RayCastResult;
import com.github.stephengold.joltjni.RayCastSettings;
import com.github.stephengold.joltjni.ShapeCastSettings;
import com.github.stephengold.joltjni.ShapeFilter;
import com.github.stephengold.joltjni.TransformedShapeCollector;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstNarrowPhaseQuery;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class NarrowPhaseQuery
extends NonCopyable
implements ConstNarrowPhaseQuery {
    NarrowPhaseQuery(PhysicsSystem system, long queryVa) {
        super(system, queryVa);
    }

    public PhysicsSystem getSystem() {
        return (PhysicsSystem)this.getContainingObject();
    }

    @Override
    public boolean castRay(RRayCast raycast, RayCastResult hitResult) {
        boolean result = this.castRay(raycast, hitResult, new BroadPhaseLayerFilter());
        return result;
    }

    @Override
    public boolean castRay(RRayCast raycast, RayCastResult hitResult, BroadPhaseLayerFilter bplFilter) {
        boolean result = this.castRay(raycast, hitResult, bplFilter, new ObjectLayerFilter());
        return result;
    }

    @Override
    public boolean castRay(RRayCast raycast, RayCastResult hitResult, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        boolean result = this.castRay(raycast, hitResult, bplFilter, olFilter, new BodyFilter());
        return result;
    }

    @Override
    public boolean castRay(RRayCast raycast, RayCastResult hitResult, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        long queryVa = this.va();
        long raycastVa = raycast.va();
        long hitResultVa = hitResult.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        boolean result = NarrowPhaseQuery.castRay(queryVa, raycastVa, hitResultVa, bplFilterVa, olFilterVa, bodyFilterVa);
        return result;
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector) {
        this.castRay(raycast, settings, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.castRay(raycast, settings, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        this.castRay(raycast, settings, collector, bplFilter, olFilter, new BodyFilter());
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        this.castRay(raycast, settings, collector, bplFilter, olFilter, bodyFilter, new ShapeFilter());
    }

    @Override
    public void castRay(RRayCast raycast, RayCastSettings settings, CastRayCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter) {
        long queryVa = this.va();
        long raycastVa = raycast.va();
        long settingsVa = settings.va();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        NarrowPhaseQuery.castRay(queryVa, raycastVa, settingsVa, collectorVa, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa);
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector) {
        this.castShape(shapeCast, settings, base, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.castShape(shapeCast, settings, base, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        this.castShape(shapeCast, settings, base, collector, bplFilter, olFilter, new BodyFilter());
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        this.castShape(shapeCast, settings, base, collector, bplFilter, olFilter, bodyFilter, new ShapeFilter());
    }

    @Override
    public void castShape(RShapeCast shapeCast, ShapeCastSettings settings, RVec3Arg base, CastShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter) {
        long queryVa = this.va();
        long shapeCastVa = shapeCast.va();
        long settingsVa = settings.va();
        double baseX = base.xx();
        double baseY = base.yy();
        double baseZ = base.zz();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        NarrowPhaseQuery.castShape(queryVa, shapeCastVa, settingsVa, baseX, baseY, baseZ, collectorVa, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa);
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector) {
        this.collectTransformedShapes(box, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collectTransformedShapes(box, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        this.collectTransformedShapes(box, collector, bplFilter, olFilter, new BodyFilter());
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        this.collectTransformedShapes(box, collector, bplFilter, olFilter, bodyFilter, new ShapeFilter());
    }

    @Override
    public void collectTransformedShapes(ConstAaBox box, TransformedShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter) {
        long queryVa = this.va();
        long boxVa = box.targetVa();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        NarrowPhaseQuery.collectTransformedShapes(queryVa, boxVa, collectorVa, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa);
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector) {
        this.collidePoint(point, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collidePoint(point, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        this.collidePoint(point, collector, bplFilter, olFilter, new BodyFilter());
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        this.collidePoint(point, collector, bplFilter, olFilter, bodyFilter, new ShapeFilter());
    }

    @Override
    public void collidePoint(RVec3Arg point, CollidePointCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter) {
        long queryVa = this.va();
        double xx = point.xx();
        double yy = point.yy();
        double zz = point.zz();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        NarrowPhaseQuery.collidePoint(queryVa, xx, yy, zz, collectorVa, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa);
    }

    @Override
    public void collideShape(ConstShape shape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector) {
        this.collideShape(shape, shapeScale, comTransform, settings, base, collector, new BroadPhaseLayerFilter());
    }

    @Override
    public void collideShape(ConstShape shape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector, BroadPhaseLayerFilter bplFilter) {
        this.collideShape(shape, shapeScale, comTransform, settings, base, collector, bplFilter, new ObjectLayerFilter());
    }

    @Override
    public void collideShape(ConstShape shape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter) {
        this.collideShape(shape, shapeScale, comTransform, settings, base, collector, bplFilter, olFilter, new BodyFilter());
    }

    @Override
    public void collideShape(ConstShape shape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter) {
        this.collideShape(shape, shapeScale, comTransform, settings, base, collector, bplFilter, olFilter, bodyFilter, new ShapeFilter());
    }

    @Override
    public void collideShape(ConstShape shape, Vec3Arg shapeScale, RMat44Arg comTransform, CollideShapeSettings settings, RVec3Arg base, CollideShapeCollector collector, BroadPhaseLayerFilter bplFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter) {
        long queryVa = this.va();
        long shapeVa = shape.targetVa();
        float sx = shapeScale.getX();
        float sy = shapeScale.getY();
        float sz = shapeScale.getZ();
        long transformVa = comTransform.targetVa();
        long settingsVa = settings.va();
        double baseX = base.xx();
        double baseY = base.yy();
        double baseZ = base.zz();
        long collectorVa = collector.va();
        long bplFilterVa = bplFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        NarrowPhaseQuery.collideShape(queryVa, shapeVa, sx, sy, sz, transformVa, settingsVa, baseX, baseY, baseZ, collectorVa, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa);
    }

    private static native boolean castRay(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void castRay(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void castShape(long var0, long var2, long var4, double var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20);

    private static native void collectTransformedShapes(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void collidePoint(long var0, double var2, double var4, double var6, long var8, long var10, long var12, long var14, long var16);

    private static native void collideShape(long var0, long var2, float var4, float var5, float var6, long var7, long var9, double var11, double var13, double var15, long var17, long var19, long var21, long var23, long var25);
}

