/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Color;
import com.github.stephengold.joltjni.PhysicsMaterialRef;
import com.github.stephengold.joltjni.PhysicsMaterialRefC;
import com.github.stephengold.joltjni.PhysicsMaterialResult;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;

public class PhysicsMaterial
extends SerializableObject
implements ConstPhysicsMaterial {
    PhysicsMaterial() {
    }

    PhysicsMaterial(long materialVa) {
        this.setVirtualAddressAsCoOwner(materialVa);
    }

    public static ConstPhysicsMaterial sDefault() {
        long materialVa = PhysicsMaterial.sDefault(true);
        PhysicsMaterial result = new PhysicsMaterial(materialVa);
        return result;
    }

    public static PhysicsMaterialResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = PhysicsMaterial.sRestoreFromBinaryState(streamVa);
        PhysicsMaterialResult result = new PhysicsMaterialResult(resultVa, true);
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long materialVa) {
        long refVa = PhysicsMaterial.toRef(materialVa);
        Runnable freeingAction = () -> PhysicsMaterialRef.free(refVa);
        this.setVirtualAddress(materialVa, freeingAction);
    }

    @Override
    public Color getDebugColor() {
        long materialVa = this.va();
        int intColor = PhysicsMaterial.getDebugColor(materialVa);
        Color result = new Color(intColor);
        return result;
    }

    @Override
    public String getDebugName() {
        long materialVa = this.va();
        String result = PhysicsMaterial.getDebugName(materialVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long materialVa = this.va();
        long streamVa = stream.va();
        PhysicsMaterial.saveBinaryState(materialVa, streamVa);
    }

    @Override
    public PhysicsMaterialRefC toRefC() {
        long materialVa = this.va();
        long refVa = PhysicsMaterial.toRefC(materialVa);
        PhysicsMaterialRefC result = new PhysicsMaterialRefC(refVa, true);
        return result;
    }

    @Override
    public int getRefCount() {
        long materialVa = this.va();
        int result = PhysicsMaterial.getRefCount(materialVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long materialVa = this.va();
        PhysicsMaterial.setEmbedded(materialVa);
    }

    @Override
    public PhysicsMaterialRef toRef() {
        long materialVa = this.va();
        long copyVa = PhysicsMaterial.toRef(materialVa);
        PhysicsMaterialRef result = new PhysicsMaterialRef(copyVa, true);
        return result;
    }

    private static native int getDebugColor(long var0);

    private static native String getDebugName(long var0);

    private static native int getRefCount(long var0);

    private static native void saveBinaryState(long var0, long var2);

    private static native long sDefault(boolean var0);

    private static native void setEmbedded(long var0);

    private static native long sRestoreFromBinaryState(long var0);

    private static native long toRef(long var0);

    private static native long toRefC(long var0);
}

