/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.PhysicsScene;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.template.Ref;

public final class PhysicsSceneRef
extends Ref {
    public PhysicsSceneRef() {
        long refVa = PhysicsSceneRef.createDefault();
        this.setVirtualAddress(refVa, () -> PhysicsSceneRef.free(refVa));
    }

    PhysicsSceneRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> PhysicsSceneRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void addBody(ConstBodyCreationSettings body) {
        long sceneVa = this.targetVa();
        long bodyVa = body.targetVa();
        PhysicsScene.addBody(sceneVa, bodyVa);
    }

    public void addConstraint(TwoBodyConstraintSettings constraint, int body1, int body2) {
        long sceneVa = this.targetVa();
        long constraintVa = constraint.va();
        PhysicsScene.addConstraint(sceneVa, constraintVa, body1, body2);
    }

    public void addSoftBody(SoftBodyCreationSettings softBody) {
        long sceneVa = this.targetVa();
        long bodyVa = softBody.va();
        PhysicsScene.addSoftBody(sceneVa, bodyVa);
    }

    public boolean createBodies(PhysicsSystem system) {
        long sceneVa = this.targetVa();
        long systemVa = system.va();
        boolean result = PhysicsScene.createBodies(sceneVa, systemVa);
        return result;
    }

    public boolean fixInvalidScales() {
        long sceneVa = this.targetVa();
        boolean result = PhysicsScene.fixInvalidScales(sceneVa);
        return result;
    }

    public void fromPhysicsSystem(PhysicsSystem system) {
        long sceneVa = this.targetVa();
        long systemVa = system.va();
        PhysicsScene.fromPhysicsSystem(sceneVa, systemVa);
    }

    public BodyCreationSettings[] getBodies() {
        long sceneVa = this.targetVa();
        int numBodies = PhysicsScene.getNumBodies(sceneVa);
        BodyCreationSettings[] result = new BodyCreationSettings[numBodies];
        for (int bodyIndex = 0; bodyIndex < numBodies; ++bodyIndex) {
            long settingsVa = PhysicsScene.getBody(sceneVa, bodyIndex);
            result[bodyIndex] = new BodyCreationSettings(this, settingsVa);
        }
        return result;
    }

    public SoftBodyCreationSettings[] getSoftBodies() {
        long sceneVa = this.targetVa();
        int numBodies = PhysicsScene.getNumSoftBodies(sceneVa);
        SoftBodyCreationSettings[] result = new SoftBodyCreationSettings[numBodies];
        for (int sbIndex = 0; sbIndex < numBodies; ++sbIndex) {
            long settingsVa = PhysicsScene.getSoftBody(sceneVa, sbIndex);
            result[sbIndex] = new SoftBodyCreationSettings(this, settingsVa);
        }
        return result;
    }

    public void saveBinaryState(StreamOut stream, boolean saveShapes, boolean saveGroupFilter) {
        long sceneVa = this.targetVa();
        long streamVa = stream.va();
        PhysicsScene.saveBinaryState(sceneVa, streamVa, saveShapes, saveGroupFilter);
    }

    @Override
    public PhysicsScene getPtr() {
        long sceneVa = this.targetVa();
        PhysicsScene result = new PhysicsScene(sceneVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = PhysicsSceneRef.getPtr(refVa);
        return result;
    }

    @Override
    public PhysicsSceneRef toRef() {
        long refVa = this.va();
        long copyVa = PhysicsSceneRef.copy(refVa);
        PhysicsSceneRef result = new PhysicsSceneRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

