/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class Plane
implements ConstPlane {
    private float c;
    private float nx;
    private float ny;
    private float nz;

    public Plane(ConstPlane original) {
        this.nx = original.getNormalX();
        this.ny = original.getNormalY();
        this.nz = original.getNormalZ();
        this.c = original.getConstant();
    }

    public Plane(float nx, float ny, float nz, float c) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.c = c;
    }

    public Plane(FloatBuffer buffer) {
        this.nx = buffer.get(0);
        this.ny = buffer.get(1);
        this.nz = buffer.get(2);
        this.c = buffer.get(3);
    }

    public Plane(Vec3Arg normal, float c) {
        this.nx = normal.getX();
        this.ny = normal.getY();
        this.nz = normal.getZ();
        this.c = c;
    }

    public void set(ConstPlane source) {
        this.nx = source.getNormalX();
        this.ny = source.getNormalY();
        this.nz = source.getNormalZ();
        this.nz = source.getConstant();
    }

    public void set(float nx, float ny, float nz, float c) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.c = c;
    }

    public void set(FloatBuffer buffer) {
        this.nx = buffer.get(0);
        this.ny = buffer.get(1);
        this.nz = buffer.get(2);
        this.c = buffer.get(3);
    }

    public void setConstant(float c) {
        this.c = c;
    }

    public void setNormal(Vec3Arg normal) {
        this.nx = normal.getX();
        this.ny = normal.getY();
        this.nz = normal.getZ();
    }

    @Override
    public void copyTo(FloatBuffer storeFloats) {
        storeFloats.put(0, this.nx);
        storeFloats.put(1, this.ny);
        storeFloats.put(2, this.nz);
        storeFloats.put(3, this.c);
    }

    @Override
    public float getConstant() {
        return this.c;
    }

    @Override
    public Vec3 getNormal() {
        Vec3 result = new Vec3(this.nx, this.ny, this.nz);
        return result;
    }

    @Override
    public float getNormalX() {
        return this.nx;
    }

    @Override
    public float getNormalY() {
        return this.ny;
    }

    @Override
    public float getNormalZ() {
        return this.nz;
    }

    @Override
    public void put(FloatBuffer storeBuffer) {
        storeBuffer.put(this.nx);
        storeBuffer.put(this.ny);
        storeBuffer.put(this.nz);
        storeBuffer.put(this.c);
    }

    @Override
    public float signedDistance(Vec3Arg point) {
        float result = point.getX() * this.nx + point.getY() * this.ny + point.getZ() * this.nz + this.c;
        return result;
    }

    public String toString() {
        String result = "Plane{(" + this.nx + " " + this.ny + " " + this.nz + ") " + this.c + "}";
        return result;
    }
}

