/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.enumerate.EBackFaceMode;

public class RayCastSettings
extends JoltPhysicsObject {
    public RayCastSettings() {
        long settingsVa = RayCastSettings.createDefault();
        this.setVirtualAddress(settingsVa, () -> RayCastSettings.free(settingsVa));
    }

    public RayCastSettings(RayCastSettings original) {
        long originalVa = original.va();
        long copyVa = RayCastSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> RayCastSettings.free(copyVa));
    }

    public EBackFaceMode getBackFaceModeConvex() {
        long settingsVa = this.va();
        int ordinal = RayCastSettings.getBackFaceModeConvex(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    public EBackFaceMode getBackFaceModeTriangles() {
        long settingsVa = this.va();
        int ordinal = RayCastSettings.getBackFaceModeTriangles(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    public boolean getTreatConvexAsSolid() {
        long settingsVa = this.va();
        boolean result = RayCastSettings.getTreatConvexAsSolid(settingsVa);
        return result;
    }

    public void setBackFaceModeConvex(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        RayCastSettings.setBackFaceModeConvex(settingsVa, ordinal);
    }

    public void setBackFaceModeTriangles(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        RayCastSettings.setBackFaceModeTriangles(settingsVa, ordinal);
    }

    public void setTreatConvexAsSolid(boolean setting) {
        long settingsVa = this.va();
        RayCastSettings.setTreatConvexAsSolid(settingsVa, setting);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native int getBackFaceModeConvex(long var0);

    private static native int getBackFaceModeTriangles(long var0);

    private static native boolean getTreatConvexAsSolid(long var0);

    private static native void setBackFaceModeConvex(long var0, int var2);

    private static native void setBackFaceModeTriangles(long var0, int var2);

    private static native void setTreatConvexAsSolid(long var0, boolean var2);
}

