/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.block;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.body.util.VxVoxelShapeUtil;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class BlockRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Integer> DATA_BLOCK_STATE_ID = VxDataAccessor.create(BlockRigidBody.class, VxDataSerializers.INTEGER);

    public BlockRigidBody(VxBodyType<BlockRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public BlockRigidBody(VxBodyType<BlockRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_BLOCK_STATE_ID, class_2248.method_9507((class_2680)class_2246.field_10340.method_9564()));
    }

    public void setRepresentedBlockState(class_2680 blockState) {
        class_2680 state = blockState != null && !blockState.method_26215() ? blockState : class_2246.field_10340.method_9564();
        this.setSyncData(DATA_BLOCK_STATE_ID, class_2248.method_9507((class_2680)state));
    }

    public class_2680 getRepresentedBlockState() {
        class_2680 state = class_2248.method_9531((int)this.getSyncData(DATA_BLOCK_STATE_ID));
        return !state.method_26215() ? state : class_2246.field_10340.method_9564();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        int n;
        class_2680 stateForShape = this.getRepresentedBlockState();
        class_265 voxelShape = stateForShape.method_26220((class_1922)this.physicsWorld.getLevel(), class_2338.field_10980);
        MutableCompoundShapeSettings shapeSettings = VxVoxelShapeUtil.toMutableCompoundShape(voxelShape);
        if (shapeSettings == null) {
            VxMainClass.LOGGER.warn("VoxelShape conversion for BlockState {} failed. Using default BoxShape.", (Object)stateForShape);
            try (MutableCompoundShapeSettings boxSettings = VxVoxelShapeUtil.toMutableCompoundShape(class_2246.field_10340.method_9564().method_26220((class_1922)this.physicsWorld.getLevel(), class_2338.field_10980));){
                int n2;
                try (BodyCreationSettings bcs = new BodyCreationSettings();){
                    bcs.setMotionType(EMotionType.Dynamic);
                    bcs.setObjectLayer(1);
                    n2 = factory.create(boxSettings, bcs);
                }
                return n2;
            }
        }
        try (BodyCreationSettings bcs = new BodyCreationSettings();){
            bcs.setMotionType(EMotionType.Dynamic);
            bcs.setObjectLayer(1);
            n = factory.create(shapeSettings, bcs);
        }
        return n;
        finally {
            if (shapeSettings != null) {
                shapeSettings.close();
            }
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.method_10804(this.getSyncData(DATA_BLOCK_STATE_ID));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        int blockStateId = buf.method_10816();
        class_2680 state = class_2248.method_9531((int)blockStateId);
        if (state.method_26215()) {
            this.setSyncData(DATA_BLOCK_STATE_ID, class_2248.method_9507((class_2680)class_2246.field_10340.method_9564()));
        } else {
            this.setSyncData(DATA_BLOCK_STATE_ID, blockStateId);
        }
    }
}

