/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.drivable.car;

import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleAntiRollBar;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastCylinder;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleDifferentialSettings;
import com.github.stephengold.joltjni.VehicleEngineSettings;
import com.github.stephengold.joltjni.VehicleTransmissionSettings;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.WheeledVehicleControllerSettings;
import com.github.stephengold.joltjni.enumerate.ETransmissionMode;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import net.xmx.velthoric.physics.vehicle.type.car.VxCar;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;

public class CarImpl
extends VxCar {
    public CarImpl(VxBodyType<CarImpl> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxCar>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public CarImpl(VxBodyType<CarImpl> type, UUID id) {
        super((VxBodyType<? extends VxCar>)type, id);
    }

    @Override
    protected VehicleConstraintSettings createConstraintSettings() {
        this.wheels = new ArrayList(4);
        float wheelRadius = 0.55f;
        float wheelWidth = 0.35f;
        float halfVehicleWidth = 1.15f;
        float halfVehicleLength = 2.0f;
        float suspensionMinLength = 0.3f;
        float suspensionMaxLength = 0.7f;
        float maxSteerAngleRad = (float)Math.toRadians(35.0);
        float suspensionFrequency = 1.8f;
        float suspensionDamping = 0.8f;
        WheelSettingsWv flWheel = new WheelSettingsWv();
        flWheel.setPosition(new Vec3(-halfVehicleWidth, -0.2f, halfVehicleLength));
        flWheel.setRadius(wheelRadius);
        flWheel.setWidth(wheelWidth);
        flWheel.setSuspensionMinLength(suspensionMinLength);
        flWheel.setSuspensionMaxLength(suspensionMaxLength);
        flWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        flWheel.getSuspensionSpring().setDamping(suspensionDamping);
        flWheel.setMaxSteerAngle(maxSteerAngleRad);
        flWheel.setMaxBrakeTorque(8000.0f);
        WheelSettingsWv frWheel = new WheelSettingsWv();
        frWheel.setPosition(new Vec3(halfVehicleWidth, -0.2f, halfVehicleLength));
        frWheel.setRadius(wheelRadius);
        frWheel.setWidth(wheelWidth);
        frWheel.setSuspensionMinLength(suspensionMinLength);
        frWheel.setSuspensionMaxLength(suspensionMaxLength);
        frWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        frWheel.getSuspensionSpring().setDamping(suspensionDamping);
        frWheel.setMaxSteerAngle(maxSteerAngleRad);
        frWheel.setMaxBrakeTorque(8000.0f);
        WheelSettingsWv rlWheel = new WheelSettingsWv();
        rlWheel.setPosition(new Vec3(-halfVehicleWidth, -0.2f, -halfVehicleLength));
        rlWheel.setRadius(wheelRadius);
        rlWheel.setWidth(wheelWidth);
        rlWheel.setMaxSteerAngle(0.0f);
        rlWheel.setSuspensionMinLength(suspensionMinLength);
        rlWheel.setSuspensionMaxLength(suspensionMaxLength);
        rlWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        rlWheel.getSuspensionSpring().setDamping(suspensionDamping);
        rlWheel.setMaxBrakeTorque(4000.0f);
        WheelSettingsWv rrWheel = new WheelSettingsWv();
        rrWheel.setPosition(new Vec3(halfVehicleWidth, -0.2f, -halfVehicleLength));
        rrWheel.setRadius(wheelRadius);
        rrWheel.setWidth(wheelWidth);
        rrWheel.setMaxSteerAngle(0.0f);
        rrWheel.setSuspensionMinLength(suspensionMinLength);
        rrWheel.setSuspensionMaxLength(suspensionMaxLength);
        rrWheel.getSuspensionSpring().setFrequency(suspensionFrequency);
        rrWheel.getSuspensionSpring().setDamping(suspensionDamping);
        rrWheel.setMaxBrakeTorque(4000.0f);
        this.wheels.add(new VxWheel(flWheel));
        this.wheels.add(new VxWheel(frWheel));
        this.wheels.add(new VxWheel(rlWheel));
        this.wheels.add(new VxWheel(rrWheel));
        this.setSyncData(DATA_WHEELS_SETTINGS, this.wheels.stream().map(VxWheel::getSettings).collect(Collectors.toList()));
        WheeledVehicleControllerSettings controllerSettings = new WheeledVehicleControllerSettings();
        VehicleEngineSettings engineSettings = controllerSettings.getEngine();
        engineSettings.setMaxTorque(7500.0f);
        engineSettings.setMaxRpm(9000.0f);
        engineSettings.setMinRpm(1000.0f);
        VehicleTransmissionSettings transmissionSettings = controllerSettings.getTransmission();
        transmissionSettings.setMode(ETransmissionMode.Auto);
        transmissionSettings.setGearRatios(4.0f, 2.5f, 1.8f, 1.3f, 1.0f);
        transmissionSettings.setReverseGearRatios(-3.5f);
        transmissionSettings.setShiftUpRpm(8000.0f);
        transmissionSettings.setShiftDownRpm(3000.0f);
        controllerSettings.setNumDifferentials(1);
        float limitedSlipRatio = 3.0f;
        VehicleDifferentialSettings rearDifferential = controllerSettings.getDifferential(0);
        rearDifferential.setLeftWheel(2);
        rearDifferential.setRightWheel(3);
        rearDifferential.setDifferentialRatio(4.11f);
        rearDifferential.setEngineTorqueRatio(1.0f);
        rearDifferential.setLimitedSlipRatio(limitedSlipRatio);
        VehicleConstraintSettings settings = new VehicleConstraintSettings();
        settings.addWheels(flWheel, frWheel, rlWheel, rrWheel);
        settings.setController(controllerSettings);
        settings.setNumAntiRollBars(2);
        VehicleAntiRollBar frontArb = settings.getAntiRollBar(0);
        frontArb.setLeftWheel(0);
        frontArb.setRightWheel(1);
        frontArb.setStiffness(3000.0f);
        VehicleAntiRollBar rearArb = settings.getAntiRollBar(1);
        rearArb.setLeftWheel(2);
        rearArb.setRightWheel(3);
        rearArb.setStiffness(3000.0f);
        return settings;
    }

    @Override
    protected VehicleCollisionTester createCollisionTester() {
        return new VehicleCollisionTesterCastCylinder(1);
    }

    @Override
    public void defineSeats(VxSeat.Builder builder) {
        Vector3f frontOffset = new Vector3f(0.0f, 0.5f, 0.5f);
        class_238 frontAABB = new class_238((double)frontOffset.x - 0.3, (double)frontOffset.y - 0.4, (double)frontOffset.z - 0.3, (double)frontOffset.x + 0.3, (double)frontOffset.y + 0.4, (double)frontOffset.z + 0.3);
        String frontIdentifier = "front_seat";
        VxSeat frontSeat = new VxSeat(this.getPhysicsId(), frontIdentifier, frontAABB, frontOffset, true);
        Vector3f rearOffset = new Vector3f(0.0f, 0.5f, -0.5f);
        class_238 rearAABB = new class_238((double)rearOffset.x - 0.3, (double)rearOffset.y - 0.4, (double)rearOffset.z - 0.3, (double)rearOffset.x + 0.3, (double)rearOffset.y + 0.4, (double)rearOffset.z + 0.3);
        String rearIdentifier = "rear_seat";
        VxSeat rearSeat = new VxSeat(this.getPhysicsId(), rearIdentifier, rearAABB, rearOffset, false);
        builder.addSeat(frontSeat);
        builder.addSeat(rearSeat);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

