/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.drivable.motorcycle;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.MotorcycleControllerSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleCollisionTester;
import com.github.stephengold.joltjni.VehicleCollisionTesterCastCylinder;
import com.github.stephengold.joltjni.VehicleConstraintSettings;
import com.github.stephengold.joltjni.VehicleDifferentialSettings;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.github.stephengold.joltjni.operator.Op;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import net.xmx.velthoric.physics.vehicle.type.motorcycle.VxMotorcycle;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheel;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Vector3f;

public class MotorcycleImpl
extends VxMotorcycle {
    public MotorcycleImpl(VxBodyType<MotorcycleImpl> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxMotorcycle>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public MotorcycleImpl(VxBodyType<MotorcycleImpl> type, UUID id) {
        super((VxBodyType<? extends VxMotorcycle>)type, id);
    }

    @Override
    protected VehicleConstraintSettings createConstraintSettings() {
        this.wheels = new ArrayList(2);
        float back_wheel_radius = 0.31f;
        float back_wheel_width = 0.05f;
        float back_wheel_pos_z = -0.75f;
        float back_suspension_min_length = 0.3f;
        float back_suspension_max_length = 0.5f;
        float back_suspension_freq = 2.0f;
        float back_brake_torque = 250.0f;
        float front_wheel_radius = 0.31f;
        float front_wheel_width = 0.05f;
        float front_wheel_pos_z = 0.75f;
        float front_suspension_min_length = 0.3f;
        float front_suspension_max_length = 0.5f;
        float front_suspension_freq = 1.5f;
        float front_brake_torque = 500.0f;
        float half_vehicle_height = 0.3f;
        float max_steering_angle = Jolt.degreesToRadians(30.0f);
        float caster_angle = Jolt.degreesToRadians(30.0f);
        VehicleConstraintSettings vehicle = new VehicleConstraintSettings();
        vehicle.setMaxPitchRollAngle(Jolt.degreesToRadians(60.0f));
        vehicle.setUp(new Vec3(0.0f, 1.0f, 0.0f));
        WheelSettingsWv front = new WheelSettingsWv();
        front.setPosition(new Vec3(0.0f, -0.27f, 0.75f));
        front.setMaxSteerAngle(max_steering_angle);
        front.setSuspensionDirection(new Vec3(0.0f, -1.0f, (float)Math.tan(caster_angle)).normalized());
        front.setSteeringAxis(Op.minus(front.getSuspensionDirection()));
        front.setRadius(0.31f);
        front.setWidth(0.05f);
        front.setSuspensionMinLength(0.3f);
        front.setSuspensionMaxLength(0.5f);
        front.getSuspensionSpring().setFrequency(1.5f);
        front.setMaxBrakeTorque(500.0f);
        WheelSettingsWv back = new WheelSettingsWv();
        back.setPosition(new Vec3(0.0f, -0.27f, -0.75f));
        back.setMaxSteerAngle(0.0f);
        back.setRadius(0.31f);
        back.setWidth(0.05f);
        back.setSuspensionMinLength(0.3f);
        back.setSuspensionMaxLength(0.5f);
        back.getSuspensionSpring().setFrequency(2.0f);
        back.setMaxBrakeTorque(250.0f);
        this.wheels.add(new VxWheel(front));
        this.wheels.add(new VxWheel(back));
        this.setSyncData(DATA_WHEELS_SETTINGS, this.wheels.stream().map(VxWheel::getSettings).collect(Collectors.toList()));
        vehicle.addWheels(front, back);
        MotorcycleControllerSettings controller = new MotorcycleControllerSettings();
        controller.getEngine().setMaxTorque(150.0f);
        controller.getEngine().setMinRpm(1000.0f);
        controller.getEngine().setMaxRpm(10000.0f);
        controller.getTransmission().setShiftDownRpm(2000.0f);
        controller.getTransmission().setShiftUpRpm(8000.0f);
        controller.getTransmission().setGearRatios(2.27f, 1.63f, 1.3f, 1.09f, 0.96f, 0.88f);
        controller.getTransmission().setReverseGearRatios(-4.0f);
        controller.getTransmission().setClutchStrength(2.0f);
        vehicle.setController(controller);
        controller.setNumDifferentials(1);
        VehicleDifferentialSettings differential = controller.getDifferential(0);
        differential.setLeftWheel(-1);
        differential.setRightWheel(1);
        differential.setDifferentialRatio(4.825f);
        return vehicle;
    }

    @Override
    protected VehicleCollisionTester createCollisionTester() {
        return new VehicleCollisionTesterCastCylinder(1, 0.025f);
    }

    @Override
    public void defineSeats(VxSeat.Builder builder) {
        Vector3f seatOffset = new Vector3f(0.0f, 0.4f, 0.1f);
        class_238 seatAABB = new class_238((double)seatOffset.x - 0.3, (double)seatOffset.y - 0.4, (double)seatOffset.z - 0.3, (double)seatOffset.x + 0.3, (double)seatOffset.y + 0.4, (double)seatOffset.z + 0.3);
        String seatIdentifier = "driver_seat";
        VxSeat driverSeat = new VxSeat(this.getPhysicsId(), seatIdentifier, seatAABB, seatOffset, true);
        builder.addSeat(driverSeat);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

