/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.debug;

import java.util.function.ToIntFunction;
import net.minecraft.class_1921;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.xmx.velthoric.physics.body.client.time.VxFrameTimer;

public class VxPhysicsDebugChart {
    public static void draw(class_332 guiGraphics, class_327 font, VxFrameTimer frameTimer, int x, int width, int baseY, ToIntFunction<Integer> colorSampler) {
        int i;
        int recordedFrames = frameTimer.getFrameCount();
        if (recordedFrames == 0) {
            return;
        }
        long[] log = frameTimer.getLog();
        int logEnd = frameTimer.getLogEnd();
        int chartHeight = 60;
        int barsToDisplay = Math.min(recordedFrames, width);
        long totalTime = 0L;
        int minTime = Integer.MAX_VALUE;
        int maxTime = Integer.MIN_VALUE;
        for (i = 0; i < barsToDisplay; ++i) {
            int logIndex = frameTimer.wrapIndex(logEnd - 1 - i);
            int timeMs = (int)(log[logIndex] / 1000000L);
            minTime = Math.min(minTime, timeMs);
            maxTime = Math.max(maxTime, timeMs);
            totalTime += (long)timeMs;
        }
        guiGraphics.method_51739(class_1921.method_51785(), x, baseY - 60, x + width, baseY, -1873784752);
        for (i = 0; i < barsToDisplay; ++i) {
            int currentX = x + width - 1 - i;
            int logIndex = frameTimer.wrapIndex(logEnd - 1 - i);
            long durationNanos = log[logIndex];
            int scaledHeight = frameTimer.scaleSampleTo(durationNanos, 30, 60);
            int color = colorSampler.applyAsInt(class_3532.method_15340((int)scaledHeight, (int)0, (int)60));
            guiGraphics.method_51739(class_1921.method_51785(), currentX, baseY - scaledHeight, currentX + 1, baseY, color);
        }
        guiGraphics.method_51738(class_1921.method_51785(), x, x + width - 1, baseY - 60, -1);
        guiGraphics.method_51738(class_1921.method_51785(), x, x + width - 1, baseY - 1, -1);
        guiGraphics.method_51742(class_1921.method_51785(), x, baseY - 60, baseY, -1);
        guiGraphics.method_51742(class_1921.method_51785(), x + width - 1, baseY - 60, baseY, -1);
        guiGraphics.method_51739(class_1921.method_51785(), x + 1, baseY - 60 + 1, x + 40, baseY - 60 + 10, -1873784752);
        guiGraphics.method_51433(font, "Physics", x + 2, baseY - 60 + 2, 0xE0E0E0, false);
        String minText = (minTime == Integer.MAX_VALUE ? 0 : minTime) + " ms min";
        String avgText = (barsToDisplay > 0 ? totalTime / (long)barsToDisplay : 0L) + " ms avg";
        String maxText = (maxTime == Integer.MIN_VALUE ? 0 : maxTime) + " ms max";
        guiGraphics.method_51433(font, minText, x + 2, baseY - 60 - 9, 0xE0E0E0, false);
        guiGraphics.method_25300(font, avgText, x + width / 2, baseY - 60 - 9, 0xE0E0E0);
        guiGraphics.method_25303(font, maxText, x + width - font.method_1727(maxText), baseY - 60 - 9, 0xE0E0E0);
    }
}

