/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.item.chaincreator.body;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BoxShapeSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionQuality;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class VxChainPartRigidBody
extends VxRigidBody {
    private static final VxDataAccessor<Float> DATA_LENGTH = VxDataAccessor.create(VxChainPartRigidBody.class, VxDataSerializers.FLOAT);
    private static final VxDataAccessor<Float> DATA_RADIUS = VxDataAccessor.create(VxChainPartRigidBody.class, VxDataSerializers.FLOAT);

    public VxChainPartRigidBody(VxBodyType<VxChainPartRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @Environment(value=EnvType.CLIENT)
    public VxChainPartRigidBody(VxBodyType<VxChainPartRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_LENGTH, Float.valueOf(0.8f));
        builder.define(DATA_RADIUS, Float.valueOf(0.1f));
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        super.writePersistenceData(buf);
        buf.writeFloat(this.getSyncData(DATA_LENGTH).floatValue());
        buf.writeFloat(this.getSyncData(DATA_RADIUS).floatValue());
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        super.readPersistenceData(buf);
        this.setSyncData(DATA_LENGTH, Float.valueOf(buf.readFloat()));
        this.setSyncData(DATA_RADIUS, Float.valueOf(buf.readFloat()));
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        float currentRadius = this.getSyncData(DATA_RADIUS).floatValue();
        float currentLength = this.getSyncData(DATA_LENGTH).floatValue();
        Vec3 halfExtents = new Vec3(currentRadius, currentLength / 2.0f, currentRadius);
        try (BoxShapeSettings shapeSettings = new BoxShapeSettings(halfExtents);){
            int n;
            try (BodyCreationSettings bcs = new BodyCreationSettings();){
                bcs.setMotionType(EMotionType.Dynamic);
                bcs.setObjectLayer(1);
                bcs.setFriction(0.5f);
                bcs.setMotionQuality(EMotionQuality.LinearCast);
                bcs.setRestitution(0.1f);
                n = factory.create(shapeSettings, bcs);
            }
            return n;
        }
    }

    public float getLength() {
        return this.getSyncData(DATA_LENGTH).floatValue();
    }

    public float getRadius() {
        return this.getSyncData(DATA_RADIUS).floatValue();
    }

    public static VxDataAccessor<Float> getLengthAccessor() {
        return DATA_LENGTH;
    }

    public static VxDataAccessor<Float> getRadiusAccessor() {
        return DATA_RADIUS;
    }
}

