/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.math;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import java.util.Optional;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.xmx.velthoric.math.VxTransform;

public class VxOBB {
    private static final double EPSILON = 1.0E-7;
    public final VxTransform transform;
    public final class_238 localAABB;

    public VxOBB(VxTransform transform, class_238 localAABB) {
        this.transform = transform.copy();
        this.localAABB = localAABB;
    }

    public VxOBB(VxTransform transform, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.transform = transform.copy();
        this.localAABB = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static VxOBB ofSize(VxTransform transform, class_243 center, double xSize, double ySize, double zSize) {
        class_238 local = new class_238(-xSize / 2.0, -ySize / 2.0, -zSize / 2.0, xSize / 2.0, ySize / 2.0, zSize / 2.0);
        VxTransform newTransform = transform.copy();
        newTransform.getTranslation().set(center.field_1352, center.field_1351, center.field_1350);
        return new VxOBB(newTransform, local);
    }

    public class_243 getCenter() {
        RVec3 center = this.transform.getTranslation();
        return new class_243(center.xx(), center.yy(), center.zz());
    }

    public class_243 getExtents() {
        return new class_243(this.localAABB.method_17939() / 2.0, this.localAABB.method_17940() / 2.0, this.localAABB.method_17941() / 2.0);
    }

    public VxOBB move(double x, double y, double z) {
        VxTransform newTransform = this.transform.copy();
        RVec3 translation = newTransform.getTranslation();
        translation.set(translation.xx() + x, translation.yy() + y, translation.zz() + z);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB move(class_243 vec) {
        return this.move(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public VxOBB rotate(Quat rotation) {
        VxTransform newTransform = this.transform.copy();
        Quat resultRotation = Op.star((QuatArg)newTransform.getRotation(), (QuatArg)rotation);
        newTransform.getRotation().set(resultRotation);
        return new VxOBB(newTransform, this.localAABB);
    }

    public VxOBB inflate(double value) {
        return new VxOBB(this.transform, this.localAABB.method_1014(value));
    }

    public VxOBB inflate(double x, double y, double z) {
        return new VxOBB(this.transform, this.localAABB.method_1009(x, y, z));
    }

    public VxOBB deflate(double value) {
        return new VxOBB(this.transform, this.localAABB.method_1011(value));
    }

    public boolean contains(class_243 point) {
        class_243 localPoint = this.transformToLocal(point);
        return this.localAABB.method_1006(localPoint);
    }

    public boolean intersects(VxOBB other) {
        double rb;
        int i;
        class_243 extentsA = this.getExtents();
        Quat rotA = this.transform.getRotation();
        class_243[] axesA = new class_243[]{VxOBB.toMcVec3(rotA.rotateAxisX()), VxOBB.toMcVec3(rotA.rotateAxisY()), VxOBB.toMcVec3(rotA.rotateAxisZ())};
        class_243 extentsB = other.getExtents();
        Quat rotB = other.transform.getRotation();
        class_243[] axesB = new class_243[]{VxOBB.toMcVec3(rotB.rotateAxisX()), VxOBB.toMcVec3(rotB.rotateAxisY()), VxOBB.toMcVec3(rotB.rotateAxisZ())};
        class_243 t = other.getCenter().method_1020(this.getCenter());
        double[][] R = new double[3][3];
        double[][] absR = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = axesA[i].method_1026(axesB[j]);
                absR[i][j] = Math.abs(R[i][j]) + 1.0E-7;
            }
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, i);
            rb = VxOBB.getComponent(extentsB, 0) * absR[i][0] + VxOBB.getComponent(extentsB, 1) * absR[i][1] + VxOBB.getComponent(extentsB, 2) * absR[i][2];
            if (!(Math.abs(axesA[i].method_1026(t)) > ra + rb)) continue;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            double ra = VxOBB.getComponent(extentsA, 0) * absR[0][i] + VxOBB.getComponent(extentsA, 1) * absR[1][i] + VxOBB.getComponent(extentsA, 2) * absR[2][i];
            rb = VxOBB.getComponent(extentsB, i);
            double projection = axesB[i].method_1026(t);
            if (!(Math.abs(projection) > ra + rb)) continue;
            return false;
        }
        double ra = extentsA.field_1351 * absR[2][0] + extentsA.field_1350 * absR[1][0];
        double rb2 = extentsB.field_1351 * absR[0][2] + extentsB.field_1350 * absR[0][1];
        if (Math.abs(t.field_1350 * R[1][0] - t.field_1351 * R[2][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1351 * absR[2][1] + extentsA.field_1350 * absR[1][1];
        rb2 = extentsB.field_1352 * absR[0][2] + extentsB.field_1350 * absR[0][0];
        if (Math.abs(t.field_1350 * R[1][1] - t.field_1351 * R[2][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1351 * absR[2][2] + extentsA.field_1350 * absR[1][2];
        rb2 = extentsB.field_1352 * absR[0][1] + extentsB.field_1351 * absR[0][0];
        if (Math.abs(t.field_1350 * R[1][2] - t.field_1351 * R[2][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[2][0] + extentsA.field_1350 * absR[0][0];
        rb2 = extentsB.field_1351 * absR[1][2] + extentsB.field_1350 * absR[1][1];
        if (Math.abs(t.field_1352 * R[2][0] - t.field_1350 * R[0][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[2][1] + extentsA.field_1350 * absR[0][1];
        rb2 = extentsB.field_1352 * absR[1][2] + extentsB.field_1350 * absR[1][0];
        if (Math.abs(t.field_1352 * R[2][1] - t.field_1350 * R[0][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[2][2] + extentsA.field_1350 * absR[0][2];
        rb2 = extentsB.field_1352 * absR[1][1] + extentsB.field_1351 * absR[1][0];
        if (Math.abs(t.field_1352 * R[2][2] - t.field_1350 * R[0][2]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[1][0] + extentsA.field_1351 * absR[0][0];
        rb2 = extentsB.field_1351 * absR[2][2] + extentsB.field_1350 * absR[2][1];
        if (Math.abs(t.field_1351 * R[0][0] - t.field_1352 * R[1][0]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[1][1] + extentsA.field_1351 * absR[0][1];
        rb2 = extentsB.field_1352 * absR[2][2] + extentsB.field_1350 * absR[2][0];
        if (Math.abs(t.field_1351 * R[0][1] - t.field_1352 * R[1][1]) > ra + rb2) {
            return false;
        }
        ra = extentsA.field_1352 * absR[1][2] + extentsA.field_1351 * absR[0][2];
        rb2 = extentsB.field_1352 * absR[2][1] + extentsB.field_1351 * absR[2][0];
        return !(Math.abs(t.field_1351 * R[0][2] - t.field_1352 * R[1][2]) > ra + rb2);
    }

    public boolean intersectsWith(class_238 aabb) {
        class_243 center = aabb.method_1005();
        double hx = aabb.method_17939() / 2.0;
        double hy = aabb.method_17940() / 2.0;
        double hz = aabb.method_17941() / 2.0;
        VxTransform aabbTransform = new VxTransform(new RVec3(center.field_1352, center.field_1351, center.field_1350), new Quat());
        class_238 localAABB = new class_238(-hx, -hy, -hz, hx, hy, hz);
        VxOBB other = new VxOBB(aabbTransform, localAABB);
        return this.intersects(other);
    }

    public Optional<class_243> clip(class_243 from, class_243 to) {
        class_243 localFrom = this.transformToLocal(from);
        class_243 localTo = this.transformToLocal(to);
        Optional localHit = this.localAABB.method_992(localFrom, localTo);
        return localHit.map(this::transformToWorld);
    }

    public class_238 getBounds() {
        class_243[] corners = this.getCorners();
        class_243 min = corners[0];
        class_243 max = corners[0];
        for (int i = 1; i < 8; ++i) {
            min = new class_243(Math.min(min.field_1352, corners[i].field_1352), Math.min(min.field_1351, corners[i].field_1351), Math.min(min.field_1350, corners[i].field_1350));
            max = new class_243(Math.max(max.field_1352, corners[i].field_1352), Math.max(max.field_1351, corners[i].field_1351), Math.max(max.field_1350, corners[i].field_1350));
        }
        return new class_238(min, max);
    }

    public class_243[] getCorners() {
        class_243[] corners = new class_243[]{this.transformToWorld(new class_243(this.localAABB.field_1323, this.localAABB.field_1322, this.localAABB.field_1321)), this.transformToWorld(new class_243(this.localAABB.field_1320, this.localAABB.field_1322, this.localAABB.field_1321)), this.transformToWorld(new class_243(this.localAABB.field_1320, this.localAABB.field_1325, this.localAABB.field_1321)), this.transformToWorld(new class_243(this.localAABB.field_1323, this.localAABB.field_1325, this.localAABB.field_1321)), this.transformToWorld(new class_243(this.localAABB.field_1323, this.localAABB.field_1322, this.localAABB.field_1324)), this.transformToWorld(new class_243(this.localAABB.field_1320, this.localAABB.field_1322, this.localAABB.field_1324)), this.transformToWorld(new class_243(this.localAABB.field_1320, this.localAABB.field_1325, this.localAABB.field_1324)), this.transformToWorld(new class_243(this.localAABB.field_1323, this.localAABB.field_1325, this.localAABB.field_1324))};
        return corners;
    }

    private class_243 transformToLocal(class_243 worldPoint) {
        RVec3 center = this.transform.getTranslation();
        RVec3 p = new RVec3(worldPoint.field_1352 - center.xx(), worldPoint.field_1351 - center.yy(), worldPoint.field_1350 - center.zz());
        Quat inverseRotation = this.transform.getRotation().conjugated();
        RVec3 localPoint = new RVec3(p);
        localPoint.rotateInPlace(inverseRotation);
        return new class_243(localPoint.xx(), localPoint.yy(), localPoint.zz());
    }

    private class_243 transformToWorld(class_243 localPoint) {
        RVec3 p = new RVec3(localPoint.field_1352, localPoint.field_1351, localPoint.field_1350);
        RVec3 rotatedPoint = new RVec3(p);
        rotatedPoint.rotateInPlace(this.transform.getRotation());
        RVec3 center = this.transform.getTranslation();
        return new class_243(rotatedPoint.xx() + center.xx(), rotatedPoint.yy() + center.yy(), rotatedPoint.zz() + center.zz());
    }

    private static class_243 toMcVec3(Vec3 joltVec) {
        return new class_243((double)joltVec.getX(), (double)joltVec.getY(), (double)joltVec.getZ());
    }

    private static double getComponent(class_243 v, int index) {
        return switch (index) {
            case 0 -> v.field_1352;
            case 1 -> v.field_1351;
            case 2 -> v.field_1350;
            default -> 0.0;
        };
    }

    public String toString() {
        return "VxOBB{transform=" + String.valueOf(this.transform) + ", localAABB=" + String.valueOf(this.localAABB) + "}";
    }
}

