/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.mixin.impl.mounting.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.xmx.velthoric.math.VxConversions;
import net.xmx.velthoric.math.VxOBB;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntityState;
import net.xmx.velthoric.physics.mounting.util.VxMountingRenderUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    class_310 field_4015;
    @Shadow
    @Final
    private class_4184 field_18765;
    @Unique
    private final Map<Integer, VxMountingEntityState> velthoric_originalStates = new HashMap<Integer, VxMountingEntityState>();
    @Unique
    private final VxTransform velthoric_interpolatedTransform = new VxTransform();

    @Shadow
    protected abstract double method_3196(class_4184 var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f method_22973(double var1);

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V", shift=At.Shift.BEFORE)})
    private void velthoric_preRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.clear();
        for (class_1297 entity : clientWorld.method_18112()) {
            class_1297 passenger;
            VxMountingEntity proxy;
            if (!(entity instanceof VxMountingEntity) || (proxy = (VxMountingEntity)entity).method_5685().isEmpty() || (passenger = proxy.method_31483()) == null) continue;
            this.velthoric_adjustEntityForRender(proxy, tickDelta);
            this.velthoric_adjustEntityForRender(passenger, tickDelta);
        }
    }

    @Unique
    private void velthoric_adjustEntityForRender(class_1297 entity, float tickDelta) {
        VxMountingEntity proxy;
        class_1297 class_12972 = entity.method_5854();
        if (class_12972 instanceof VxMountingEntity) {
            VxMountingEntity vehicleProxy;
            proxy = vehicleProxy = (VxMountingEntity)class_12972;
        } else if (entity instanceof VxMountingEntity) {
            VxMountingEntity selfProxy;
            proxy = selfProxy = (VxMountingEntity)entity;
        } else {
            return;
        }
        VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, tickDelta, this.velthoric_interpolatedTransform).ifPresent(transform -> {
            this.velthoric_originalStates.computeIfAbsent(entity.method_5628(), k -> new VxMountingEntityState()).setFrom(entity);
            Quaternionf physRotation = transform.getRotation(new Quaternionf());
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            physRotation.transform(rideOffset);
            double targetX = transform.getTranslation().xx() + (double)rideOffset.x();
            double targetY = transform.getTranslation().yy() + (double)rideOffset.y();
            double targetZ = transform.getTranslation().zz() + (double)rideOffset.z();
            entity.method_5814(targetX, targetY, targetZ);
            entity.field_6014 = targetX;
            entity.field_6036 = targetY;
            entity.field_5969 = targetZ;
            entity.field_6038 = targetX;
            entity.field_5971 = targetY;
            entity.field_5989 = targetZ;
        });
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void velthoric_postRenderLevel(float tickDelta, long startTime, boolean tick, CallbackInfo ci) {
        class_638 clientWorld = this.field_4015.field_1687;
        if (clientWorld == null) {
            return;
        }
        this.velthoric_originalStates.forEach((id, state) -> {
            class_1297 entity = clientWorld.method_8469(id.intValue());
            if (entity != null) {
                state.applyTo(entity);
            }
        });
        this.velthoric_originalStates.clear();
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void velthoric_setupCameraWithPhysicsBody(class_761 instance, class_4587 poseStack, class_243 cameraPos, Matrix4f projectionMatrix, Operation<Void> original) {
        class_746 player = this.field_4015.field_1724;
        if (player != null) {
            float partialTicks = this.field_4015.method_1488();
            VxMountingRenderUtils.INSTANCE.ifMountedOnBody((class_1297)player, partialTicks, physQuat -> {
                Quaternionf physRotation = VxConversions.toJoml(physQuat, new Quaternionf());
                poseStack.method_22907(physRotation.conjugate());
                double fov = this.method_3196(this.field_18765, partialTicks, true);
                Matrix4f newProjectionMatrix = this.method_22973(Math.max(fov, (double)((Integer)this.field_4015.field_1690.method_41808().method_41753()).intValue()));
                original.call(new Object[]{instance, poseStack, this.field_18765.method_19326(), newProjectionMatrix});
            });
        }
        original.call(new Object[]{instance, poseStack, cameraPos, projectionMatrix});
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;")})
    private class_3966 velthoric_pickEntityWithOBB(class_1297 shooter, class_243 start, class_243 end, class_238 searchBox, Predicate<class_1297> filter, double maxDistanceSq, Operation<class_3966> original) {
        Predicate<class_1297> vanillaFilter = filter.and(entity -> !(entity.method_5854() instanceof VxMountingEntity));
        class_3966 vanillaResult = (class_3966)original.call(new Object[]{shooter, start, end, searchBox, vanillaFilter, maxDistanceSq});
        double closestHitDistSq = vanillaResult != null ? start.method_1025(vanillaResult.method_17784()) : maxDistanceSq;
        class_3966 bestOverallResult = vanillaResult;
        List potentialTargets = this.field_4015.field_1687.method_8333(shooter, searchBox, filter);
        for (class_1297 target : potentialTargets) {
            double distSq;
            Optional<class_3966> obbHit;
            if (!(target.method_5854() instanceof VxMountingEntity) || !(obbHit = this.velthoric_performObbRaycast(target, start, end)).isPresent() || !((distSq = start.method_1025(obbHit.get().method_17784())) < closestHitDistSq)) continue;
            closestHitDistSq = distSq;
            bestOverallResult = obbHit.get();
        }
        return bestOverallResult;
    }

    @Unique
    private Optional<class_3966> velthoric_performObbRaycast(class_1297 target, class_243 start, class_243 end) {
        class_1297 class_12972 = target.method_5854();
        if (!(class_12972 instanceof VxMountingEntity)) {
            return Optional.empty();
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        return this.velthoric_createTargetOBB(target, proxy).flatMap(obb -> obb.clip(start, end)).map(hitPos -> new class_3966(target, hitPos));
    }

    @Unique
    private Optional<VxOBB> velthoric_createTargetOBB(class_1297 target, VxMountingEntity proxy) {
        float partialTicks = this.field_4015.method_1488();
        return VxMountingRenderUtils.INSTANCE.getInterpolatedTransform(proxy, partialTicks, this.velthoric_interpolatedTransform).map(transform -> {
            Vector3f rideOffset = new Vector3f((Vector3fc)proxy.getMountPositionOffset());
            transform.getRotation(new Quaternionf()).transform(rideOffset);
            transform.getTranslation().addInPlace(rideOffset.x(), rideOffset.y(), rideOffset.z());
            class_238 targetAABB = target.method_5829().method_1014((double)target.method_5871());
            class_238 localEntityAABB = targetAABB.method_989(-target.method_23317(), -target.method_23318(), -target.method_23321());
            return new VxOBB((VxTransform)transform, localEntityAABB);
        });
    }
}

