/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.xmx.velthoric.physics.buoyancy.VxFluidType;

public abstract class AbstractDataStore {
    protected long[] grow(long[] src, int size) {
        return src == null ? new long[size] : Arrays.copyOf(src, size);
    }

    protected float[] grow(float[] src, int size) {
        return src == null ? new float[size] : Arrays.copyOf(src, size);
    }

    protected boolean[] grow(boolean[] src, int size) {
        return src == null ? new boolean[size] : Arrays.copyOf(src, size);
    }

    protected float[][] grow(float[][] src, int size) {
        return src == null ? new float[size][] : (float[][])((float[][])Arrays.copyOf(src, size));
    }

    protected EBodyType[] grow(EBodyType[] src, int size) {
        return src == null ? new EBodyType[size] : Arrays.copyOf(src, size);
    }

    protected EMotionType[] grow(EMotionType[] src, int size) {
        return src == null ? new EMotionType[size] : Arrays.copyOf(src, size);
    }

    protected ByteBuffer[] grow(ByteBuffer[] src, int size) {
        return src == null ? new ByteBuffer[size] : Arrays.copyOf(src, size);
    }

    protected RVec3[] grow(RVec3[] src, int size) {
        int oldSize = src == null ? 0 : src.length;
        RVec3[] dest = Arrays.copyOf(src != null ? src : new RVec3[]{}, size);
        for (int i = oldSize; i < size; ++i) {
            dest[i] = new RVec3();
        }
        return dest;
    }

    protected int[] grow(int[] src, int size) {
        return src == null ? new int[size] : Arrays.copyOf(src, size);
    }

    protected ShapeRefC[] grow(ShapeRefC[] src, int size) {
        return src == null ? new ShapeRefC[size] : Arrays.copyOf(src, size);
    }

    protected VxFluidType[] grow(VxFluidType[] src, int size) {
        return src == null ? new VxFluidType[size] : Arrays.copyOf(src, size);
    }
}

