/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CRemoveBodyBatchPacket {
    private final List<Integer> networkIds;

    public S2CRemoveBodyBatchPacket(List<Integer> networkIds) {
        this.networkIds = networkIds;
    }

    public static void encode(S2CRemoveBodyBatchPacket msg, class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(msg.networkIds.size());
            for (Integer id : msg.networkIds) {
                tempBuf.method_10804(id.intValue());
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10804(uncompressedData.length);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress remove body batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CRemoveBodyBatchPacket decode(class_2540 buf) {
        int uncompressedSize = buf.method_10816();
        byte[] compressedData = buf.method_10795();
        try {
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.method_10816();
            IntArrayList ids = new IntArrayList(size);
            for (int i = 0; i < size; ++i) {
                ids.add(decompressedBuf.method_10816());
            }
            return new S2CRemoveBodyBatchPacket((List<Integer>)ids);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress remove body batch packet", e);
        }
    }

    public static void handle(S2CRemoveBodyBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (int networkId : msg.networkIds) {
                manager.removeBody(networkId);
            }
        });
    }
}

