/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;

public class S2CSynchronizedDataBatchPacket {
    private final Map<Integer, byte[]> dataUpdates;

    public S2CSynchronizedDataBatchPacket(Map<Integer, byte[]> dataUpdates) {
        this.dataUpdates = dataUpdates;
    }

    public static void encode(S2CSynchronizedDataBatchPacket msg, class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(msg.dataUpdates.size());
            for (Map.Entry<Integer, byte[]> entry : msg.dataUpdates.entrySet()) {
                tempBuf.method_10804(entry.getKey().intValue());
                tempBuf.method_10813(entry.getValue());
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10804(uncompressedData.length);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress sync data batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CSynchronizedDataBatchPacket decode(class_2540 buf) {
        try {
            int uncompressedSize = buf.method_10816();
            byte[] compressedData = buf.method_10795();
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int size = decompressedBuf.method_10816();
            Int2ObjectArrayMap dataUpdates = new Int2ObjectArrayMap(size);
            for (int i = 0; i < size; ++i) {
                int id = decompressedBuf.method_10816();
                byte[] data = decompressedBuf.method_10795();
                dataUpdates.put(id, data);
            }
            return new S2CSynchronizedDataBatchPacket((Map<Integer, byte[]>)dataUpdates);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress sync data batch packet", e);
        }
    }

    public static void handle(S2CSynchronizedDataBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            for (Map.Entry<Integer, byte[]> entry : msg.dataUpdates.entrySet()) {
                manager.updateSynchronizedData(entry.getKey(), Unpooled.wrappedBuffer((byte[])entry.getValue()));
            }
        });
    }
}

