/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.body.packet.batch;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.xmx.velthoric.network.VxPacketUtils;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import org.jetbrains.annotations.Nullable;

public class S2CUpdateVerticesBatchPacket {
    private final int count;
    private final int[] networkIds;
    private final float[][] vertexData;

    public S2CUpdateVerticesBatchPacket(int count, int[] networkIds, float[] @Nullable [] vertexData) {
        this.count = count;
        this.networkIds = networkIds;
        this.vertexData = vertexData;
    }

    public static void encode(S2CUpdateVerticesBatchPacket msg, class_2540 buf) {
        class_2540 tempBuf = new class_2540(Unpooled.buffer());
        try {
            tempBuf.method_10804(msg.count);
            for (int i = 0; i < msg.count; ++i) {
                tempBuf.method_10804(msg.networkIds[i]);
                float[] vertices = msg.vertexData[i];
                if (vertices != null && vertices.length > 0) {
                    tempBuf.writeBoolean(true);
                    tempBuf.method_10804(vertices.length);
                    for (float v : vertices) {
                        tempBuf.writeFloat(v);
                    }
                    continue;
                }
                tempBuf.writeBoolean(false);
            }
            byte[] uncompressedData = new byte[tempBuf.readableBytes()];
            tempBuf.readBytes(uncompressedData);
            byte[] compressedData = VxPacketUtils.compress(uncompressedData);
            buf.method_10804(uncompressedData.length);
            buf.method_10813(compressedData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress vertex batch packet", e);
        }
        finally {
            tempBuf.release();
        }
    }

    public static S2CUpdateVerticesBatchPacket decode(class_2540 buf) {
        try {
            int uncompressedSize = buf.method_10816();
            byte[] compressedData = buf.method_10795();
            byte[] decompressedData = VxPacketUtils.decompress(compressedData, uncompressedSize);
            class_2540 decompressedBuf = new class_2540(Unpooled.wrappedBuffer((byte[])decompressedData));
            int count = decompressedBuf.method_10816();
            int[] networkIds = new int[count];
            float[][] vertexData = new float[count][];
            for (int i = 0; i < count; ++i) {
                networkIds[i] = decompressedBuf.method_10816();
                if (decompressedBuf.readBoolean()) {
                    int length = decompressedBuf.method_10816();
                    vertexData[i] = new float[length];
                    for (int j = 0; j < length; ++j) {
                        vertexData[i][j] = decompressedBuf.readFloat();
                    }
                    continue;
                }
                vertexData[i] = null;
            }
            return new S2CUpdateVerticesBatchPacket(count, networkIds, vertexData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decompress vertex batch packet", e);
        }
    }

    public static void handle(S2CUpdateVerticesBatchPacket msg, Supplier<NetworkManager.PacketContext> contextSupplier) {
        NetworkManager.PacketContext context = contextSupplier.get();
        context.queue(() -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            VxClientBodyDataStore store = manager.getStore();
            for (int i = 0; i < msg.count; ++i) {
                Integer index = store.getIndexForNetworkId(msg.networkIds[i]);
                if (index == null) continue;
                store.state1_vertexData[index.intValue()] = msg.vertexData[i];
            }
        });
    }
}

