/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.manager;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_3222;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.init.registry.EntityRegistry;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.type.VxBody;
import net.xmx.velthoric.physics.mounting.VxMountable;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;
import net.xmx.velthoric.physics.mounting.input.VxMountInput;
import net.xmx.velthoric.physics.mounting.seat.VxSeat;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VxMountingManager {
    private final VxPhysicsWorld world;
    private final Object2ObjectMap<UUID, Map<UUID, VxSeat>> bodyToSeatsMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, UUID> playerToPhysicsIdMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, Map<UUID, class_3222>> bodyToRidersMap = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<UUID, VxSeat> playerToSeatMap = new Object2ObjectOpenHashMap();

    public VxMountingManager(VxPhysicsWorld world) {
        this.world = world;
    }

    public void onBodyAdded(VxBody body) {
        if (body instanceof VxMountable) {
            VxMountable mountable = (VxMountable)((Object)body);
            VxSeat.Builder seatBuilder = new VxSeat.Builder();
            mountable.defineSeats(seatBuilder);
            List<VxSeat> seats = seatBuilder.build();
            for (VxSeat seat : seats) {
                this.addSeat(body.getPhysicsId(), seat);
            }
        }
    }

    public void onBodyRemoved(VxBody body) {
        if (body instanceof VxMountable) {
            this.bodyToSeatsMap.remove((Object)body.getPhysicsId());
        }
    }

    public void addSeat(UUID physicsId, VxSeat seat) {
        ((Map)this.bodyToSeatsMap.computeIfAbsent((Object)physicsId, k -> new ConcurrentHashMap())).put(seat.getId(), seat);
    }

    public void removeSeat(UUID physicsId, UUID seatId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        if (seats != null) {
            seats.remove(seatId);
            if (seats.isEmpty()) {
                this.bodyToSeatsMap.remove((Object)physicsId);
            }
        }
    }

    public void requestMounting(class_3222 player, UUID physicsId, UUID seatId) {
        VxBody body = this.world.getBodyManager().getVxBody(physicsId);
        if (!(body instanceof VxMountable)) {
            VxMainClass.LOGGER.warn("Player {} requested to mount non-mountable body {}", (Object)player.method_5477().getString(), (Object)physicsId);
            return;
        }
        VxMountable mountable = (VxMountable)((Object)body);
        Optional<VxSeat> seatOpt = this.getSeat(physicsId, seatId);
        if (seatOpt.isEmpty()) {
            VxMainClass.LOGGER.warn("Player {} requested to mount non-existent seat '{}' on body {}", (Object)player.method_5477().getString(), (Object)seatId, (Object)physicsId);
            return;
        }
        VxSeat seat = seatOpt.get();
        double reachDistance = player.method_7337() ? 5.0 : 4.5;
        double distanceSq = player.method_33571().method_1028((double)body.getTransform().getTranslation().x(), (double)body.getTransform().getTranslation().y(), (double)body.getTransform().getTranslation().z());
        if (distanceSq > reachDistance * reachDistance) {
            VxMainClass.LOGGER.warn("Player {} is too far to mount body {} (distSq: {}, reach: {})", (Object)player.method_5477().getString(), (Object)physicsId, (Object)distanceSq, (Object)reachDistance);
            return;
        }
        this.startMounting(player, mountable, seat);
    }

    public void startMounting(class_3222 player, VxMountable mountable, VxSeat seat) {
        if (player.method_37908().method_8608() || this.isMounting(player) || this.isSeatOccupied(mountable.getPhysicsId(), seat)) {
            return;
        }
        VxMountingEntity proxy = new VxMountingEntity((class_1299)EntityRegistry.MOUNTING_ENTITY.get(), player.method_37908());
        proxy.setMountInfo(mountable.getPhysicsId(), seat.getId());
        VxTransform initialTransform = mountable.getTransform();
        RVec3 initialPos = initialTransform.getTranslation();
        Quat initialRot = initialTransform.getRotation();
        Quaternionf initialQuat = new Quaternionf(initialRot.getX(), initialRot.getY(), initialRot.getZ(), initialRot.getW());
        Vector3f worldOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
        initialQuat.transform(worldOffset);
        double finalX = initialPos.x() + worldOffset.x();
        double finalY = initialPos.y() + worldOffset.y();
        double finalZ = initialPos.z() + worldOffset.z();
        Vector3f eulerAngles = new Vector3f();
        initialQuat.getEulerAnglesXYZ(eulerAngles);
        proxy.method_5814(finalX, finalY, finalZ);
        proxy.method_36456((float)Math.toDegrees(eulerAngles.y));
        this.world.getLevel().method_8649((class_1297)proxy);
        player.method_5873((class_1297)proxy, true);
        this.registerMountingInternal(player, mountable.getPhysicsId(), seat);
        mountable.onStartMounting(player, seat);
    }

    public void restoreMounting(class_3222 player, UUID physicsId, UUID seatId) {
        Optional<VxSeat> seatOpt = this.getSeat(physicsId, seatId);
        if (seatOpt.isPresent()) {
            this.registerMountingInternal(player, physicsId, seatOpt.get());
        }
    }

    private void registerMountingInternal(class_3222 player, UUID physicsId, VxSeat seat) {
        ((Map)this.bodyToRidersMap.computeIfAbsent((Object)physicsId, k -> Maps.newHashMap())).put(player.method_5667(), player);
        this.playerToPhysicsIdMap.put((Object)player.method_5667(), (Object)physicsId);
        this.playerToSeatMap.put((Object)player.method_5667(), (Object)seat);
    }

    public void stopMounting(class_3222 player) {
        Map riders;
        if (!this.isMounting(player)) {
            return;
        }
        Optional<VxMountable> mountableOpt = this.getMountableForPlayer(player);
        UUID playerUuid = player.method_5667();
        UUID physicsId = (UUID)this.playerToPhysicsIdMap.remove((Object)playerUuid);
        this.playerToSeatMap.remove((Object)playerUuid);
        if (physicsId != null && (riders = (Map)this.bodyToRidersMap.get((Object)physicsId)) != null) {
            riders.remove(playerUuid);
            if (riders.isEmpty()) {
                this.bodyToRidersMap.remove((Object)physicsId);
            }
        }
        mountableOpt.ifPresent(mountable -> mountable.onStopMounting(player));
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof VxMountingEntity) {
            player.method_5848();
            vehicle.method_31472();
        }
    }

    public void onGameTick() {
        ArrayList<class_3222> playersToStopMounting = new ArrayList<class_3222>();
        HashSet objectIds = Sets.newHashSet((Iterable)this.bodyToRidersMap.keySet());
        for (UUID physicsId : objectIds) {
            VxBody physBody;
            Map riders = (Map)this.bodyToRidersMap.get((Object)physicsId);
            if (riders == null || (physBody = this.world.getBodyManager().getVxBody(physicsId)) == null) continue;
            VxTransform trans = physBody.getTransform();
            RVec3 pos = trans.getTranslation();
            Quat rot = trans.getRotation();
            Quaternionf jomlQuat = new Quaternionf(rot.getX(), rot.getY(), rot.getZ(), rot.getW());
            Vector3f eulerAngles = new Vector3f();
            jomlQuat.getEulerAnglesXYZ(eulerAngles);
            float yawDegrees = (float)Math.toDegrees(eulerAngles.y);
            for (class_3222 rider : Sets.newHashSet(riders.values())) {
                if (rider.method_31481() || !rider.method_5765() || !(rider.method_5854() instanceof VxMountingEntity)) {
                    playersToStopMounting.add(rider);
                    continue;
                }
                VxSeat seat = (VxSeat)this.playerToSeatMap.get((Object)rider.method_5667());
                if (seat != null) {
                    class_1297 vehicle = rider.method_5854();
                    Vector3f rideOffset = new Vector3f((Vector3fc)seat.getRiderOffset());
                    jomlQuat.transform(rideOffset);
                    double finalX = pos.x() + rideOffset.x();
                    double finalY = pos.y() + rideOffset.y();
                    double finalZ = pos.z() + rideOffset.z();
                    vehicle.method_5814(finalX, finalY, finalZ);
                    vehicle.method_36456(yawDegrees);
                    vehicle.method_5847(yawDegrees);
                    vehicle.field_6037 = true;
                    continue;
                }
                playersToStopMounting.add(rider);
            }
        }
        for (class_3222 player : playersToStopMounting) {
            this.stopMounting(player);
        }
    }

    public void handlePlayerInput(class_3222 player, VxMountInput input) {
        if (!this.isMounting(player)) {
            return;
        }
        this.getSeatForPlayer(player).ifPresent(seat -> {
            if (seat.isDriverSeat()) {
                this.getMountableForPlayer(player).ifPresent(mountable -> mountable.handleDriverInput(player, input));
            }
        });
    }

    public void onPlayerDisconnect(class_3222 player) {
        if (this.isMounting(player)) {
            this.stopMounting(player);
        }
    }

    public boolean isMounting(class_3222 player) {
        return this.playerToPhysicsIdMap.containsKey((Object)player.method_5667());
    }

    public boolean isSeatOccupied(UUID physicsId, VxSeat seat) {
        Map riders = (Map)this.bodyToRidersMap.get((Object)physicsId);
        if (riders == null || riders.isEmpty()) {
            return false;
        }
        for (UUID riderUuid : riders.keySet()) {
            VxSeat occupiedSeat = (VxSeat)this.playerToSeatMap.get((Object)riderUuid);
            if (occupiedSeat == null || !occupiedSeat.getId().equals(seat.getId())) continue;
            return true;
        }
        return false;
    }

    public Optional<VxSeat> getSeat(UUID physicsId, UUID seatId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        return seats != null ? Optional.ofNullable((VxSeat)seats.get(seatId)) : Optional.empty();
    }

    public Collection<VxSeat> getSeats(UUID physicsId) {
        Map seats = (Map)this.bodyToSeatsMap.get((Object)physicsId);
        return seats != null ? seats.values() : Collections.emptyList();
    }

    public Optional<VxSeat> getSeatForPlayer(class_3222 player) {
        return Optional.ofNullable((VxSeat)this.playerToSeatMap.get((Object)player.method_5667()));
    }

    public Optional<VxMountable> getMountableForPlayer(class_3222 player) {
        UUID physicsId = (UUID)this.playerToPhysicsIdMap.get((Object)player.method_5667());
        if (physicsId == null) {
            return Optional.empty();
        }
        VxBody body = this.world.getBodyManager().getVxBody(physicsId);
        if (body instanceof VxMountable) {
            return Optional.of((VxMountable)((Object)body));
        }
        return Optional.empty();
    }

    public Map<UUID, Map<UUID, VxSeat>> getAllSeatsByBody() {
        return Collections.unmodifiableMap(this.bodyToSeatsMap);
    }
}

