/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.mounting.util;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.xmx.velthoric.math.VxTransform;
import net.xmx.velthoric.physics.body.client.VxClientBodyDataStore;
import net.xmx.velthoric.physics.body.client.VxClientBodyManager;
import net.xmx.velthoric.physics.mounting.entity.VxMountingEntity;

public enum VxMountingRenderUtils {
    INSTANCE;

    private final RVec3 tempPosition = new RVec3();
    private final Quat tempRotation = new Quat();

    public Optional<VxTransform> getInterpolatedTransform(VxMountingEntity proxy, float partialTicks, VxTransform transformOut) {
        return proxy.getPhysicsId().flatMap(id -> this.getValidBodyIndex((UUID)id).map(index -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            manager.getInterpolator().interpolateFrame(manager.getStore(), (int)index, partialTicks, this.tempPosition, this.tempRotation);
            transformOut.set(this.tempPosition, this.tempRotation);
            return transformOut;
        }));
    }

    public void ifMountedOnBody(class_1297 entity, float partialTicks, Consumer<Quat> action) {
        class_1297 class_12972 = entity.method_5854();
        if (!(class_12972 instanceof VxMountingEntity)) {
            return;
        }
        VxMountingEntity proxy = (VxMountingEntity)class_12972;
        proxy.getPhysicsId().flatMap(this::getValidBodyIndex).ifPresent(index -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            manager.getInterpolator().interpolateRotation(manager.getStore(), (int)index, partialTicks, this.tempRotation);
            action.accept(this.tempRotation);
        });
    }

    public Optional<Quat> getInterpolatedRotation(VxMountingEntity proxy, float partialTicks) {
        return proxy.getPhysicsId().flatMap(this::getValidBodyIndex).map(index -> {
            VxClientBodyManager manager = VxClientBodyManager.getInstance();
            manager.getInterpolator().interpolateRotation(manager.getStore(), (int)index, partialTicks, this.tempRotation);
            return this.tempRotation;
        });
    }

    private Optional<Integer> getValidBodyIndex(UUID bodyId) {
        VxClientBodyManager manager = VxClientBodyManager.getInstance();
        VxClientBodyDataStore store = manager.getStore();
        Integer index = store.getIndexForId(bodyId);
        if (index == null || !store.render_isInitialized[index]) {
            return Optional.empty();
        }
        return Optional.of(index);
    }
}

