/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.physics.terrain.cache;

import com.github.stephengold.joltjni.ShapeRefC;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class VxTerrainShapeCache {
    private final LinkedHashMap<Integer, ShapeRefC> cache;
    private final int capacity;

    public VxTerrainShapeCache(int capacity) {
        this.capacity = capacity;
        this.cache = new LinkedHashMap<Integer, ShapeRefC>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, ShapeRefC> eldest) {
                boolean shouldRemove;
                boolean bl = shouldRemove = this.size() > VxTerrainShapeCache.this.capacity;
                if (shouldRemove && eldest.getValue() != null) {
                    eldest.getValue().close();
                }
                return shouldRemove;
            }
        };
    }

    public synchronized ShapeRefC get(int key) {
        ShapeRefC masterRef = this.cache.get(key);
        if (masterRef != null && masterRef.getPtr() != null) {
            return masterRef.getPtr().toRefC();
        }
        return null;
    }

    public synchronized void put(int key, ShapeRefC shape) {
        if (shape == null) {
            return;
        }
        ShapeRefC oldShape = this.cache.put(key, shape);
        if (oldShape != null && oldShape != shape) {
            oldShape.close();
        }
    }

    public synchronized void clear() {
        this.cache.values().forEach(shapeRef -> {
            if (shapeRef != null) {
                shapeRef.close();
            }
        });
        this.cache.clear();
    }

    public synchronized Map<Integer, ShapeRefC> getEntries() {
        return Collections.unmodifiableMap(new LinkedHashMap<Integer, ShapeRefC>(this.cache));
    }
}

