/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CastRayCollector;
import com.github.stephengold.joltjni.RayCastResult;
import java.util.ArrayList;
import java.util.List;

public class AllHitCastRayCollector
extends CastRayCollector {
    public AllHitCastRayCollector() {
        long collectorVa = AllHitCastRayCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitCastRayCollector.countHits(collectorVa);
        return result;
    }

    public RayCastResult get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitCastRayCollector.getHit(collectorVa, index);
        RayCastResult result = new RayCastResult(this, hitVa);
        return result;
    }

    public List<RayCastResult> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitCastRayCollector.countHits(collectorVa);
        ArrayList<RayCastResult> result = new ArrayList<RayCastResult>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitCastRayCollector.getHit(collectorVa, i);
            result.add(new RayCastResult(this, hitVa));
        }
        return result;
    }

    public void sort() {
        long collectorVa = this.va();
        AllHitCastRayCollector.sort(collectorVa);
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitCastRayCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);

    private static native void sort(long var0);
}

