/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BroadPhaseCastResult;
import com.github.stephengold.joltjni.RayCastBodyCollector;
import java.util.ArrayList;
import java.util.List;

public class AllHitRayCastBodyCollector
extends RayCastBodyCollector {
    public AllHitRayCastBodyCollector() {
        long collectorVa = AllHitRayCastBodyCollector.createDefault();
        this.setVirtualAddressAsOwner(collectorVa);
    }

    public int countHits() {
        long collectorVa = this.va();
        int result = AllHitRayCastBodyCollector.countHits(collectorVa);
        return result;
    }

    public BroadPhaseCastResult get(int index) {
        long collectorVa = this.va();
        long hitVa = AllHitRayCastBodyCollector.getHit(collectorVa, index);
        BroadPhaseCastResult result = new BroadPhaseCastResult(this, hitVa);
        return result;
    }

    public List<BroadPhaseCastResult> getHits() {
        long collectorVa = this.va();
        int numHits = AllHitRayCastBodyCollector.countHits(collectorVa);
        ArrayList<BroadPhaseCastResult> result = new ArrayList<BroadPhaseCastResult>(numHits);
        for (int i = 0; i < numHits; ++i) {
            long hitVa = AllHitRayCastBodyCollector.getHit(collectorVa, i);
            BroadPhaseCastResult hit = new BroadPhaseCastResult(this, hitVa);
            result.add(hit);
        }
        return result;
    }

    public void sort() {
        long collectorVa = this.va();
        AllHitRayCastBodyCollector.sort(collectorVa);
    }

    @Override
    public void reset() {
        long collectorVa = this.va();
        AllHitRayCastBodyCollector.reset(collectorVa);
    }

    private static native int countHits(long var0);

    private static native long createDefault();

    private static native long getHit(long var0, int var2);

    private static native void reset(long var0);

    private static native void sort(long var0);
}

