/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.BodyLockMultiBase;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterface;

public class BodyLockMultiRead
extends BodyLockMultiBase {
    private final ConstBodyLockInterface bli;

    public BodyLockMultiRead(ConstBodyLockInterface bli, int ... bodyIds) {
        this.bli = bli;
        long interfaceVa = bli.targetVa();
        long lockVa = BodyLockMultiRead.create(interfaceVa, bodyIds);
        Runnable freeingAction = () -> BodyLockMultiRead.free(lockVa);
        this.setVirtualAddress(lockVa, freeingAction);
    }

    @Override
    public ConstBody[] getBodies() {
        long lockVa = this.va();
        int numRequested = BodyLockMultiRead.getNumBodies(lockVa);
        ConstBody[] result = new Body[numRequested];
        PhysicsSystem system = this.bli.getSystem();
        for (int index = 0; index < numRequested; ++index) {
            long bodyVa = BodyLockMultiRead.getBody(lockVa, index);
            result[index] = bodyVa == 0L ? null : new Body(system, bodyVa);
        }
        return result;
    }

    @Override
    public ConstBody getBody(int index) {
        Body result;
        assert (index >= 0) : index;
        long lockVa = this.va();
        long bodyVa = BodyLockMultiRead.getBody(lockVa, index);
        if (bodyVa == 0L) {
            result = null;
        } else {
            PhysicsSystem system = this.bli.getSystem();
            result = new Body(system, bodyVa);
        }
        return result;
    }

    @Override
    public int getNumBodies() {
        long lockVa = this.va();
        int result = BodyLockMultiRead.getNumBodies(lockVa);
        return result;
    }

    @Override
    public void releaseLocks() {
        long lockVa = this.va();
        BodyLockMultiRead.releaseLocks(lockVa);
    }

    private static native long create(long var0, int[] var2);

    private static native void free(long var0);

    private static native long getBody(long var0, int var2);

    private static native int getNumBodies(long var0);

    private static native void releaseLocks(long var0);
}

