/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyFilter;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.CharacterBase;
import com.github.stephengold.joltjni.CharacterContactListener;
import com.github.stephengold.joltjni.CharacterVirtualRef;
import com.github.stephengold.joltjni.CharacterVirtualRefC;
import com.github.stephengold.joltjni.CharacterVirtualSettings;
import com.github.stephengold.joltjni.CharacterVsCharacterCollision;
import com.github.stephengold.joltjni.Contact;
import com.github.stephengold.joltjni.ExtendedUpdateSettings;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.ShapeFilter;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtual;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtualSettings;
import com.github.stephengold.joltjni.readonly.ConstContact;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class CharacterVirtual
extends CharacterBase
implements ConstCharacterVirtual {
    private CharacterContactListener contactListener;
    private CharacterVsCharacterCollision cvcInterface;
    private final PhysicsSystem system;

    public CharacterVirtual(ConstCharacterVirtualSettings settings, RVec3Arg location, QuatArg orientation, long userData, PhysicsSystem system) {
        this.system = system;
        long settingsVa = settings.targetVa();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        float qw = orientation.getW();
        long systemVa = system.va();
        long characterVa = CharacterVirtual.createCharacterVirtual(settingsVa, locX, locY, locZ, qx, qy, qz, qw, userData, systemVa);
        long refVa = CharacterVirtual.toRef(characterVa);
        this.setVirtualAddress(characterVa, () -> CharacterVirtualRef.freeWithSystem(refVa, system));
    }

    public CharacterVirtual(long characterVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        long refVa = CharacterVirtual.toRef(characterVa);
        this.setVirtualAddress(characterVa, () -> CharacterVirtualRef.freeWithSystem(refVa, physicsSystem));
    }

    public void extendedUpdate(float deltaTime, Vec3Arg gravity, ExtendedUpdateSettings settings, BroadPhaseLayerFilter bpFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter, TempAllocator allocator) {
        long characterVa = this.va();
        float gravityX = gravity.getX();
        float gravityY = gravity.getY();
        float gravityZ = gravity.getZ();
        long settingsVa = settings.va();
        long bpFilterVa = bpFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        long allocatorVa = allocator.va();
        CharacterVirtual.extendedUpdate(characterVa, deltaTime, gravityX, gravityY, gravityZ, settingsVa, bpFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa, allocatorVa);
    }

    public CharacterVsCharacterCollision getCharacterVsCharacterCollision() {
        return this.cvcInterface;
    }

    public CharacterContactListener getListener() {
        return this.contactListener;
    }

    public void setCharacterVsCharacterCollision(CharacterVsCharacterCollision cvcInterface) {
        this.cvcInterface = cvcInterface;
        long characterVa = this.va();
        long interfaceVa = cvcInterface.va();
        CharacterVirtual.setCharacterVsCharacterCollision(characterVa, interfaceVa);
    }

    public void setEnhancedInternalEdgeRemoval(boolean enable) {
        long characterVa = this.va();
        CharacterVirtual.setEnhancedInternalEdgeRemoval(characterVa, enable);
    }

    public void setHitReductionCosMaxAngle(float cosine) {
        long characterVa = this.va();
        CharacterVirtual.setHitReductionCosMaxAngle(characterVa, cosine);
    }

    public void setInnerBodyShape(ConstShape shape) {
        long characterVa = this.va();
        long shapeVa = shape.targetVa();
        CharacterVirtual.setInnerBodyShape(characterVa, shapeVa);
    }

    public void setLinearVelocity(float vx, float vy, float vz) {
        long characterVa = this.va();
        CharacterVirtual.setLinearVelocity(characterVa, vx, vy, vz);
    }

    public void setLinearVelocity(Vec3Arg velocity) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(vx, vy, vz);
    }

    public void setListener(CharacterContactListener listener) {
        this.contactListener = listener;
        long characterVa = this.va();
        long listenerVa = listener.targetVa();
        CharacterVirtual.setListener(characterVa, listenerVa);
    }

    public void setMass(float mass) {
        long characterVa = this.va();
        CharacterVirtual.setMass(characterVa, mass);
    }

    public void setMaxNumHits(int maxHits) {
        long characterVa = this.va();
        CharacterVirtual.setMaxNumHits(characterVa, maxHits);
    }

    public void setMaxStrength(float force) {
        long characterVa = this.va();
        CharacterVirtual.setMaxStrength(characterVa, force);
    }

    public void setPenetrationRecoverySpeed(float fraction) {
        long characterVa = this.va();
        CharacterVirtual.setPenetrationRecoverySpeed(characterVa, fraction);
    }

    public void setPosition(RVec3Arg location) {
        long characterVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        CharacterVirtual.setPosition(characterVa, locX, locY, locZ);
    }

    public void setRotation(QuatArg orientation) {
        long characterVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        CharacterVirtual.setRotation(characterVa, qx, qy, qz, qw);
    }

    public boolean setShape(ConstShape shape, float maxPenetrationDepth, BroadPhaseLayerFilter broadPhaseLayerFilter, ObjectLayerFilter objectLayerFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter, TempAllocator allocator) {
        long characterVa = this.va();
        long shapeVa = shape.targetVa();
        long bplFilterVa = broadPhaseLayerFilter.va();
        long olFilterVa = objectLayerFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        long allocatorVa = allocator.va();
        boolean result = CharacterVirtual.setShape(characterVa, shapeVa, maxPenetrationDepth, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa, allocatorVa);
        return result;
    }

    public void setShapeOffset(Vec3Arg offset) {
        long characterVa = this.va();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        CharacterVirtual.setShapeOffset(characterVa, dx, dy, dz);
    }

    public void setUserData(long userData) {
        long characterVa = this.va();
        CharacterVirtual.setUserData(characterVa, userData);
    }

    public void updateGroundVelocity() {
        long characterVa = this.va();
        CharacterVirtual.updateGroundVelocity(characterVa);
    }

    @Override
    public CharacterVirtualRef toRef() {
        long characterVa = this.va();
        long refVa = CharacterVirtual.toRef(characterVa);
        CharacterVirtualRef result = new CharacterVirtualRef(refVa, this.system);
        return result;
    }

    @Override
    public Vec3 cancelVelocityTowardsSteepSlopes(Vec3Arg desiredVelocity) {
        long characterVa = this.va();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        float[] storeVelocity = new float[3];
        CharacterVirtual.cancelVelocityTowardsSteepSlopes(characterVa, vx, vy, vz, storeVelocity);
        Vec3 result = new Vec3(storeVelocity);
        return result;
    }

    @Override
    public boolean canWalkStairs(Vec3Arg desiredVelocity) {
        long characterVa = this.va();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        boolean result = CharacterVirtual.canWalkStairs(characterVa, vx, vy, vz);
        return result;
    }

    @Override
    public ConstContact[] getActiveContacts() {
        long characterVa = this.va();
        int numContacts = CharacterVirtual.countActiveContacts(characterVa);
        ConstContact[] result = new ConstContact[numContacts];
        for (int i = 0; i < numContacts; ++i) {
            long contactVa = CharacterVirtual.getActiveContact(characterVa, i);
            result[i] = new Contact(contactVa, true);
        }
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        long characterVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getCenterOfMassPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public RMat44 getCenterOfMassTransform() {
        long characterVa = this.va();
        long matrixVa = CharacterVirtual.getCenterOfMassTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public float getCharacterPadding() {
        long characterVa = this.va();
        float result = CharacterVirtual.getCharacterPadding(characterVa);
        return result;
    }

    @Override
    public CharacterVirtualSettings getCharacterVirtualSettings() {
        long characterVa = this.va();
        long settingsVa = CharacterVirtual.getCharacterVirtualSettings(characterVa);
        CharacterVirtualSettings result = new CharacterVirtualSettings(settingsVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long characterVa = this.va();
        boolean result = CharacterVirtual.getEnhancedInternalEdgeRemoval(characterVa);
        return result;
    }

    @Override
    public float getHitReductionCosMaxAngle() {
        long characterVa = this.va();
        float result = CharacterVirtual.getHitReductionCosMaxAngle(characterVa);
        return result;
    }

    @Override
    public int getId() {
        long characterVa = this.va();
        int result = CharacterVirtual.getId(characterVa);
        return result;
    }

    @Override
    public int getInnerBodyId() {
        long characterVa = this.va();
        int result = CharacterVirtual.getInnerBodyId(characterVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getLinearVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMass() {
        long characterVa = this.va();
        float result = CharacterVirtual.getMass(characterVa);
        return result;
    }

    @Override
    public boolean getMaxHitsExceeded() {
        long characterVa = this.va();
        boolean result = CharacterVirtual.getMaxHitsExceeded(characterVa);
        return result;
    }

    @Override
    public int getMaxNumHits() {
        long characterVa = this.va();
        int result = CharacterVirtual.getMaxNumHits(characterVa);
        return result;
    }

    @Override
    public float getMaxStrength() {
        long characterVa = this.va();
        float result = CharacterVirtual.getMaxStrength(characterVa);
        return result;
    }

    @Override
    public float getPenetrationRecoverySpeed() {
        long characterVa = this.va();
        float result = CharacterVirtual.getPenetrationRecoverySpeed(characterVa);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long characterVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        long characterVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        storeLocation.set(storeDoubles);
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        storeOrientation.set(storeFloats);
    }

    @Override
    public Quat getRotation() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public Vec3 getShapeOffset() {
        long characterVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getShapeOffset(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape() {
        long characterVa = this.va();
        long resultVa = CharacterVirtual.getTransformedShape(characterVa);
        TransformedShape result = new TransformedShape(resultVa, true);
        return result;
    }

    @Override
    public long getUserData() {
        long characterVa = this.va();
        long result = CharacterVirtual.getUserData(characterVa);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        long characterVa = this.va();
        long matrixVa = CharacterVirtual.getWorldTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public boolean hasCollidedWith(int bodyId) {
        long characterVa = this.va();
        boolean result = CharacterVirtual.hasCollidedWithBody(characterVa, bodyId);
        return result;
    }

    @Override
    public boolean hasCollidedWith(ConstCharacterVirtual otherCharacter) {
        long characterVa = this.va();
        long otherVa = otherCharacter.targetVa();
        boolean result = CharacterVirtual.hasCollidedWithCharacter(characterVa, otherVa);
        return result;
    }

    @Override
    public CharacterVirtualRefC toRefC() {
        long characterVa = this.va();
        long refVa = CharacterVirtual.toRefC(characterVa);
        CharacterVirtualRefC result = new CharacterVirtualRefC(refVa, this.system);
        return result;
    }

    static native void cancelVelocityTowardsSteepSlopes(long var0, float var2, float var3, float var4, float[] var5);

    static native boolean canWalkStairs(long var0, float var2, float var3, float var4);

    static native int countActiveContacts(long var0);

    private static native long createCharacterVirtual(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, long var12, long var14);

    static native void extendedUpdate(long var0, float var2, float var3, float var4, float var5, long var6, long var8, long var10, long var12, long var14, long var16);

    static native long getActiveContact(long var0, int var2);

    static native void getCenterOfMassPosition(long var0, DoubleBuffer var2);

    static native long getCenterOfMassTransform(long var0);

    static native float getCharacterPadding(long var0);

    static native long getCharacterVirtualSettings(long var0);

    static native boolean getEnhancedInternalEdgeRemoval(long var0);

    static native float getHitReductionCosMaxAngle(long var0);

    static native int getId(long var0);

    static native int getInnerBodyId(long var0);

    static native void getLinearVelocity(long var0, FloatBuffer var2);

    static native float getMass(long var0);

    static native boolean getMaxHitsExceeded(long var0);

    static native int getMaxNumHits(long var0);

    static native float getMaxStrength(long var0);

    static native float getPenetrationRecoverySpeed(long var0);

    static native void getPosition(long var0, DoubleBuffer var2);

    static native void getRotation(long var0, FloatBuffer var2);

    static native void getShapeOffset(long var0, FloatBuffer var2);

    static native long getTransformedShape(long var0);

    static native long getUserData(long var0);

    static native long getWorldTransform(long var0);

    static native boolean hasCollidedWithBody(long var0, int var2);

    static native boolean hasCollidedWithCharacter(long var0, long var2);

    private static native void setCharacterVsCharacterCollision(long var0, long var2);

    private static native void setEnhancedInternalEdgeRemoval(long var0, boolean var2);

    private static native void setHitReductionCosMaxAngle(long var0, float var2);

    static native void setInnerBodyShape(long var0, long var2);

    static native void setLinearVelocity(long var0, float var2, float var3, float var4);

    private static native void setListener(long var0, long var2);

    private static native void setMass(long var0, float var2);

    private static native void setMaxNumHits(long var0, int var2);

    private static native void setMaxStrength(long var0, float var2);

    private static native void setPenetrationRecoverySpeed(long var0, float var2);

    static native void setPosition(long var0, double var2, double var4, double var6);

    static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    static native boolean setShape(long var0, long var2, float var4, long var5, long var7, long var9, long var11, long var13);

    private static native void setShapeOffset(long var0, float var2, float var3, float var4);

    private static native void setUserData(long var0, long var2);

    private static native long toRef(long var0);

    private static native long toRefC(long var0);

    static native void updateGroundVelocity(long var0);
}

