/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBaseSettings;
import com.github.stephengold.joltjni.CharacterVirtualSettings;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBackFaceMode;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtualSettings;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public final class CharacterVirtualSettingsRef
extends Ref
implements ConstCharacterVirtualSettings {
    public CharacterVirtualSettingsRef() {
        long refVa = CharacterVirtualSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> CharacterVirtualSettingsRef.free(refVa));
    }

    CharacterVirtualSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> CharacterVirtualSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void setBackFaceMode(EBackFaceMode mode) {
        long settingsVa = this.targetVa();
        int ordinal = mode.ordinal();
        CharacterVirtualSettings.setBackFaceMode(settingsVa, ordinal);
    }

    public void setCharacterPadding(float padding) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setCharacterPadding(settingsVa, padding);
    }

    public void setCollisionTolerance(float tolerance) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setCollisionTolerance(settingsVa, tolerance);
    }

    public void setEnhancedInternalEdgeRemoval(boolean remove) {
        long settingsVa = this.targetVa();
        CharacterBaseSettings.setEnhancedInternalEdgeRemoval(settingsVa, remove);
    }

    public void setHitReductionCosMaxAngle(int cosine) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setHitReductionCosMaxAngle(settingsVa, cosine);
    }

    public void setInnerBodyLayer(int objectLayer) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setInnerBodyLayer(settingsVa, objectLayer);
    }

    public void setInnerBodyShape(ConstShape shape) {
        long settingsVa = this.targetVa();
        long shapeVa = shape == null ? 0L : shape.targetVa();
        CharacterVirtualSettings.setInnerBodyShape(settingsVa, shapeVa);
    }

    public void setMass(float mass) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMass(settingsVa, mass);
    }

    public void setMaxCollisionIterations(int numIterations) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMaxCollisionIterations(settingsVa, numIterations);
    }

    public void setMaxConstraintIterations(int numIterations) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMaxConstraintIterations(settingsVa, numIterations);
    }

    public void setMaxNumHits(int numHits) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMaxNumHits(settingsVa, numHits);
    }

    public void setMaxSlopeAngle(float angle) {
        long settingsVa = this.targetVa();
        CharacterBaseSettings.setMaxSlopeAngle(settingsVa, angle);
    }

    public void setMaxStrength(float force) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMaxStrength(settingsVa, force);
    }

    public void setMinTimeRemaining(float interval) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setMinTimeRemaining(settingsVa, interval);
    }

    public void setPenetrationRecoverySpeed(float fraction) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setPenetrationRecoverySpeed(settingsVa, fraction);
    }

    public void setPredictiveContactDistance(float distance) {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings.setPredictiveContactDistance(settingsVa, distance);
    }

    public void setShape(ConstShape shape) {
        long settingsVa = this.targetVa();
        long shapeVa = shape.targetVa();
        CharacterBaseSettings.setShape(settingsVa, shapeVa);
    }

    public void setShapeOffset(Vec3Arg offset) {
        long settingsVa = this.targetVa();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        CharacterVirtualSettings.setShapeOffset(settingsVa, x, y, z);
    }

    public void setSupportingVolume(ConstPlane plane) {
        long settingsVa = this.targetVa();
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float c = plane.getConstant();
        CharacterBaseSettings.setSupportingVolume(settingsVa, nx, ny, nz, c);
    }

    public void setUp(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        CharacterBaseSettings.setUp(settingsVa, dx, dy, dz);
    }

    @Override
    public EBackFaceMode getBackFaceMode() {
        long settingsVa = this.targetVa();
        int ordinal = CharacterVirtualSettings.getBackFaceMode(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    @Override
    public float getCharacterPadding() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getCharacterPadding(settingsVa);
        return result;
    }

    @Override
    public float getCollisionTolerance() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getCollisionTolerance(settingsVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long settingsVa = this.targetVa();
        boolean result = CharacterBaseSettings.getEnhancedInternalEdgeRemoval(settingsVa);
        return result;
    }

    @Override
    public float getHitReductionCosMaxAngle() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getHitReductionCosMaxAngle(settingsVa);
        return result;
    }

    @Override
    public int getInnerBodyLayer() {
        long settingsVa = this.targetVa();
        int result = CharacterVirtualSettings.getInnerBodyLayer(settingsVa);
        return result;
    }

    @Override
    public ConstShape getInnerBodyShape() {
        long settingsVa = this.targetVa();
        long shapeVa = CharacterVirtualSettings.getInnerBodyShape(settingsVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public float getMass() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getMass(settingsVa);
        return result;
    }

    @Override
    public int getMaxCollisionIterations() {
        long settingsVa = this.targetVa();
        int result = CharacterVirtualSettings.getMaxCollisionIterations(settingsVa);
        return result;
    }

    @Override
    public int getMaxConstraintIterations() {
        long settingsVa = this.targetVa();
        int result = CharacterVirtualSettings.getMaxConstraintIterations(settingsVa);
        return result;
    }

    @Override
    public int getMaxNumHits() {
        long settingsVa = this.targetVa();
        int result = CharacterVirtualSettings.getMaxNumHits(settingsVa);
        return result;
    }

    @Override
    public float getMaxSlopeAngle() {
        long settingsVa = this.targetVa();
        float result = CharacterBaseSettings.getMaxSlopeAngle(settingsVa);
        return result;
    }

    @Override
    public float getMaxStrength() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getMaxStrength(settingsVa);
        return result;
    }

    @Override
    public float getMinTimeRemaining() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getMinTimeRemaining(settingsVa);
        return result;
    }

    @Override
    public float getPenetrationRecoverySpeed() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getPenetrationRecoverySpeed(settingsVa);
        return result;
    }

    @Override
    public float getPredictiveContactDistance() {
        long settingsVa = this.targetVa();
        float result = CharacterVirtualSettings.getPredictiveContactDistance(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.targetVa();
        int result = CharacterBaseSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long bodySettingsVa = this.targetVa();
        long shapeSettingsVa = CharacterBaseSettings.getShape(bodySettingsVa);
        Shape result = Shape.newShape(shapeSettingsVa);
        return result;
    }

    @Override
    public Vec3 getShapeOffset() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtualSettings.getShapeOffset(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Plane getSupportingVolume() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getSupportingVolume(settingsVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public CharacterVirtualSettings getPtr() {
        long settingsVa = this.targetVa();
        CharacterVirtualSettings result = new CharacterVirtualSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = CharacterVirtualSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public CharacterVirtualSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = CharacterVirtualSettingsRef.copy(refVa);
        CharacterVirtualSettingsRef result = new CharacterVirtualSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

