/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ContactListener;
import java.util.ArrayList;
import java.util.List;

public class ContactListenerList
extends ContactListener {
    private static List<ContactListener> sublisteners = new ArrayList<ContactListener>(8);

    public ContactListenerList() {
        long listVa = ContactListenerList.createDefault();
        this.setVirtualAddress(listVa, () -> ContactListenerList.free(listVa));
    }

    public synchronized void clear() {
        int size = this.size();
        sublisteners.clear();
        long listVa = this.va();
        ContactListenerList.erase(listVa, 0, size);
    }

    public synchronized boolean empty() {
        boolean result = sublisteners.isEmpty();
        return result;
    }

    public synchronized ContactListener get(int index) {
        ContactListener result = sublisteners.get(index);
        return result;
    }

    public synchronized void pushBack(ContactListener listener) {
        sublisteners.add(listener);
        long listVa = this.va();
        long listenerVa = listener.va();
        ContactListenerList.pushBack(listVa, listenerVa);
    }

    public synchronized void remove(ContactListener listener) {
        int oldSize = sublisteners.size();
        long listVa = this.va();
        for (int i = oldSize - 1; i >= 0; --i) {
            ContactListener current = sublisteners.get(i);
            if (!current.equals(listener)) continue;
            sublisteners.remove(i);
            ContactListenerList.erase(listVa, i, i + 1);
        }
    }

    public synchronized int size() {
        int result = sublisteners.size();
        return result;
    }

    public synchronized List<ContactListener> toList() {
        int size = sublisteners.size();
        ArrayList<ContactListener> result = new ArrayList<ContactListener>(size);
        result.addAll(sublisteners);
        return result;
    }

    private static native long createDefault();

    private static native void erase(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native void pushBack(long var0, long var2);
}

