/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Jolt;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Support;
import com.github.stephengold.joltjni.SupportBuffer;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.ESupportMode;
import com.github.stephengold.joltjni.readonly.ConstConvexShape;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public abstract class ConvexShape
extends Shape
implements ConstConvexShape {
    ConvexShape() {
    }

    ConvexShape(long shapeVa) {
        super(shapeVa);
    }

    public void setDensity(float density) {
        long shapeVa = this.va();
        ConvexShape.setDensity(shapeVa, density);
    }

    @Override
    public float getDensity() {
        long shapeVa = this.va();
        float result = ConvexShape.getDensity(shapeVa);
        return result;
    }

    @Override
    public void getSubmergedVolume(Mat44Arg comTransform, Vec3Arg scale, ConstPlane surface, float[] storeTotalVolume, float[] storeSubmergedVolume, Vec3 storeCenterOfBuoyancy, RVec3Arg baseOffset) {
        long shapeVa = this.va();
        long comTransformVa = comTransform.targetVa();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        floatBuffer.clear();
        scale.put(floatBuffer);
        surface.put(floatBuffer);
        boolean useBase = Jolt.implementsDebugRendering();
        double baseX = useBase ? baseOffset.xx() : 0.0;
        double baseY = useBase ? baseOffset.yy() : 0.0;
        double baseZ = useBase ? baseOffset.zz() : 0.0;
        ConvexShape.getSubmergedVolume(shapeVa, comTransformVa, floatBuffer, baseX, baseY, baseZ);
        if (storeTotalVolume != null && storeTotalVolume.length > 0) {
            storeTotalVolume[0] = floatBuffer.get(0);
        }
        if (storeSubmergedVolume != null && storeSubmergedVolume.length > 0) {
            storeSubmergedVolume[0] = floatBuffer.get(1);
        }
        if (storeCenterOfBuoyancy != null) {
            storeCenterOfBuoyancy.set(floatBuffer, 2);
        }
    }

    @Override
    public Support getSupportFunction(ESupportMode supportMode, SupportBuffer buffer, Vec3Arg scale) {
        long shapeVa = this.va();
        int ordinal = supportMode.ordinal();
        long bufferVa = buffer.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long supportVa = ConvexShape.getSupportFunction(shapeVa, ordinal, bufferVa, sx, sy, sz);
        Support result = new Support(buffer, supportVa);
        return result;
    }

    private static native float getDensity(long var0);

    private static native void getSubmergedVolume(long var0, long var2, FloatBuffer var4, double var5, double var7, double var9);

    private static native long getSupportFunction(long var0, int var2, long var3, float var5, float var6, float var7);

    private static native void setDensity(long var0, float var2);
}

