/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class GearConstraintSettings
extends TwoBodyConstraintSettings {
    public GearConstraintSettings() {
        long settingsVa = GearConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Gear);
    }

    public GearConstraintSettings(GearConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = GearConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Gear);
    }

    GearConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Gear);
    }

    public Vec3 getHingeAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        GearConstraintSettings.getHingeAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getHingeAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        GearConstraintSettings.getHingeAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getRatio() {
        long settingsVa = this.va();
        float result = GearConstraintSettings.getRatio(settingsVa);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = GearConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setHingeAxis1(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        GearConstraintSettings.setHingeAxis1(settingsVa, x, y, z);
    }

    public void setHingeAxis2(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        GearConstraintSettings.setHingeAxis2(settingsVa, x, y, z);
    }

    public void setRatio(float ratio) {
        long settingsVa = this.va();
        GearConstraintSettings.setRatio(settingsVa, ratio);
    }

    public void setRatio(int numTeeth1, int numTeeth2) {
        long settingsVa = this.va();
        GearConstraintSettings.setRatio(settingsVa, numTeeth1, numTeeth2);
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        GearConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void getHingeAxis1(long var0, FloatBuffer var2);

    private static native void getHingeAxis2(long var0, FloatBuffer var2);

    private static native float getRatio(long var0);

    private static native int getSpace(long var0);

    private static native void setHingeAxis1(long var0, float var2, float var3, float var4);

    private static native void setHingeAxis2(long var0, float var2, float var3, float var4);

    private static native void setRatio(long var0, float var2);

    private static native void setRatio(long var0, int var2, int var3);

    private static native void setSpace(long var0, int var2);
}

