/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.GroupFilter;
import com.github.stephengold.joltjni.GroupFilterTable;
import com.github.stephengold.joltjni.template.Ref;

public final class GroupFilterRef
extends Ref {
    public GroupFilterRef() {
        long refVa = GroupFilterRef.createDefault();
        this.setVirtualAddress(refVa, () -> GroupFilterRef.free(refVa));
    }

    GroupFilterRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> GroupFilterRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public GroupFilterTable getPtrAsTable() {
        long materialVa = this.targetVa();
        GroupFilterTable result = new GroupFilterTable(materialVa);
        return result;
    }

    @Override
    public GroupFilter getPtr() {
        long filterVa = this.targetVa();
        GroupFilter result = GroupFilter.newFilter(filterVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = GroupFilterRef.getPtr(refVa);
        return result;
    }

    @Override
    public Ref toRef() {
        long refVa = this.va();
        long copyVa = GroupFilterRef.copy(refVa);
        GroupFilterRef result = new GroupFilterRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

