/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.GroupFilter;
import com.github.stephengold.joltjni.GroupFilterTableRef;

public class GroupFilterTable
extends GroupFilter {
    public GroupFilterTable() {
        this(0);
    }

    public GroupFilterTable(GroupFilterTable original) {
        long originalVa = original.va();
        long copyVa = GroupFilterTable.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa);
    }

    public GroupFilterTable(int numSubGroups) {
        long filterVa = GroupFilterTable.createFilter(numSubGroups);
        this.setVirtualAddressAsCoOwner(filterVa);
    }

    GroupFilterTable(long filterVa) {
        this.setVirtualAddressAsCoOwner(filterVa);
    }

    public void disableCollision(int subGroup1, int subGroup2) {
        if (subGroup1 == subGroup2) {
            throw new IllegalArgumentException("subgroups must be distinct");
        }
        long filterVa = this.va();
        GroupFilterTable.disableCollision(filterVa, subGroup1, subGroup2);
    }

    public void enableCollision(int subGroup1, int subGroup2) {
        if (subGroup1 == subGroup2) {
            throw new IllegalArgumentException("subgroups must be distinct");
        }
        long filterVa = this.va();
        GroupFilterTable.enableCollision(filterVa, subGroup1, subGroup2);
    }

    @Override
    public GroupFilterTableRef toRef() {
        long filterVa = this.va();
        long refVa = GroupFilter.toRef(filterVa);
        GroupFilterTableRef result = new GroupFilterTableRef(refVa, true);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createFilter(int var0);

    static native void disableCollision(long var0, int var2, int var3);

    static native void enableCollision(long var0, int var2, int var3);
}

