/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class HingeConstraintSettings
extends TwoBodyConstraintSettings {
    public HingeConstraintSettings() {
        long settingsVa = HingeConstraintSettings.createHingeConstraintSettings();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Hinge);
    }

    public HingeConstraintSettings(HingeConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = HingeConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Hinge);
    }

    HingeConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Hinge);
    }

    public Vec3 getHingeAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HingeConstraintSettings.getHingeAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getHingeAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HingeConstraintSettings.getHingeAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getLimitsMax() {
        long settingsVa = this.va();
        float result = HingeConstraintSettings.getLimitsMax(settingsVa);
        return result;
    }

    public float getLimitsMin() {
        long settingsVa = this.va();
        float result = HingeConstraintSettings.getLimitsMin(settingsVa);
        return result;
    }

    public SpringSettings getLimitsSpringSettings() {
        long constraintSettingsVa = this.va();
        long springSettingsVa = HingeConstraintSettings.getLimitsSpringSettings(constraintSettingsVa);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    public float getMaxFrictionTorque() {
        long settingsVa = this.va();
        float result = HingeConstraintSettings.getMaxFrictionTorque(settingsVa);
        return result;
    }

    public MotorSettings getMotorSettings() {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = HingeConstraintSettings.getMotorSettings(constraintSettingsVa);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public Vec3 getNormalAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HingeConstraintSettings.getNormalAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getNormalAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HingeConstraintSettings.getNormalAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        HingeConstraintSettings.getPoint1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        HingeConstraintSettings.getPoint2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = HingeConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public Vec3Arg setHingeAxis1(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        HingeConstraintSettings.setHingeAxis1(settingsVa, x, y, z);
        return direction;
    }

    public Vec3Arg setHingeAxis2(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        HingeConstraintSettings.setHingeAxis2(settingsVa, x, y, z);
        return direction;
    }

    public void setLimitsMax(float limit) {
        long settingsVa = this.va();
        HingeConstraintSettings.setLimitsMax(settingsVa, limit);
    }

    public void setLimitsMin(float limit) {
        long settingsVa = this.va();
        HingeConstraintSettings.setLimitsMin(settingsVa, limit);
    }

    public void setMaxFrictionTorque(float torque) {
        long settingsVa = this.va();
        HingeConstraintSettings.setMaxFrictionTorque(settingsVa, torque);
    }

    public void setMotorSettings(MotorSettings settings) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = settings.va();
        HingeConstraintSettings.setMotorSettings(constraintSettingsVa, motorSettingsVa);
    }

    public Vec3Arg setNormalAxis1(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        HingeConstraintSettings.setNormalAxis1(settingsVa, x, y, z);
        return direction;
    }

    public Vec3Arg setNormalAxis2(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        HingeConstraintSettings.setNormalAxis2(settingsVa, x, y, z);
        return direction;
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        HingeConstraintSettings.setPoint1(settingsVa, x, y, z);
        return location;
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        HingeConstraintSettings.setPoint2(settingsVa, x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        HingeConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createHingeConstraintSettings();

    private static native void getHingeAxis1(long var0, FloatBuffer var2);

    private static native void getHingeAxis2(long var0, FloatBuffer var2);

    private static native float getLimitsMax(long var0);

    private static native float getLimitsMin(long var0);

    private static native long getLimitsSpringSettings(long var0);

    private static native float getMaxFrictionTorque(long var0);

    private static native long getMotorSettings(long var0);

    private static native void getNormalAxis1(long var0, FloatBuffer var2);

    private static native void getNormalAxis2(long var0, FloatBuffer var2);

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native void setHingeAxis1(long var0, float var2, float var3, float var4);

    private static native void setHingeAxis2(long var0, float var2, float var3, float var4);

    private static native void setLimitsMax(long var0, float var2);

    private static native void setLimitsMin(long var0, float var2);

    private static native void setMaxFrictionTorque(long var0, float var2);

    private static native void setMotorSettings(long var0, long var2);

    private static native void setNormalAxis1(long var0, float var2, float var3, float var4);

    private static native void setNormalAxis2(long var0, float var2, float var3, float var4);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);
}

