/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.readonly.Vec4Arg;
import java.nio.FloatBuffer;

public final class Mat44
extends JoltPhysicsObject
implements Mat44Arg {
    public Mat44() {
        long matrixVa = Mat44.createUninitialized();
        this.setVirtualAddress(matrixVa, () -> Mat44.free(matrixVa));
    }

    public Mat44(float ... elementArray) {
        long matrixVa = Mat44.createFromColumnMajor(elementArray);
        this.setVirtualAddress(matrixVa, () -> Mat44.free(matrixVa));
    }

    Mat44(JoltPhysicsObject container, long matrixVa) {
        super(container, matrixVa);
    }

    Mat44(long matrixVa, boolean owner) {
        Runnable freeingAction = owner ? () -> Mat44.free(matrixVa) : null;
        this.setVirtualAddress(matrixVa, freeingAction);
    }

    public Mat44(Mat44Arg original) {
        long originalVa = original.targetVa();
        long matrixVa = Mat44.createCopy(originalVa);
        this.setVirtualAddress(matrixVa, () -> Mat44.free(matrixVa));
    }

    public Mat44(RMat44Arg rMatrix) {
        long rMatrixVa = rMatrix.targetVa();
        long matrixVa = Mat44.createFromRMatrix(rMatrixVa);
        this.setVirtualAddress(matrixVa, () -> Mat44.free(matrixVa));
    }

    public Mat44(Vec4Arg c1, Vec4Arg c2, Vec4Arg c3, Vec4Arg c4) {
        this(c1.getX(), c1.getY(), c1.getZ(), c1.getW(), c2.getX(), c2.getY(), c2.getZ(), c2.getW(), c3.getX(), c3.getY(), c3.getZ(), c3.getW(), c4.getX(), c4.getY(), c4.getZ(), c4.getW());
    }

    public void leftMultiplyInPlace(Mat44Arg leftFactor) {
        long currentVa = this.va();
        long leftVa = leftFactor.targetVa();
        Mat44.leftMultiplyInPlace(currentVa, leftVa);
    }

    public void loadIdentity() {
        long matrixVa = this.va();
        Mat44.loadIdentity(matrixVa);
    }

    public static Mat44 product(Mat44Arg ... mArray) {
        long resultVa;
        int length = mArray.length;
        if (length == 0) {
            resultVa = Mat44.createIdentity();
        } else {
            long factorVa = mArray[0].targetVa();
            resultVa = Mat44.createCopy(factorVa);
            for (int i = 1; i < length; ++i) {
                factorVa = mArray[i].targetVa();
                Mat44.rightMultiplyInPlace(resultVa, factorVa);
            }
        }
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    public void rightMultiplyInPlace(Mat44Arg rightFactor) {
        long currentVa = this.va();
        long rightVa = rightFactor.targetVa();
        Mat44.rightMultiplyInPlace(currentVa, rightVa);
    }

    public void set(Mat44Arg source) {
        long targetVa = this.va();
        long sourceVa = source.targetVa();
        Mat44.assign(targetVa, sourceVa);
    }

    public void setAxisX(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        Mat44.setAxisX(matrixVa, x, y, z);
    }

    public void setAxisY(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        Mat44.setAxisY(matrixVa, x, y, z);
    }

    public void setAxisZ(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        Mat44.setAxisZ(matrixVa, x, y, z);
    }

    public void setDiagonal3(Vec3Arg vec) {
        long matrixVa = this.va();
        float x = vec.getX();
        float y = vec.getY();
        float z = vec.getZ();
        Mat44.setDiagonal3(matrixVa, x, y, z);
    }

    public void setElement(int row, int column, float value) {
        assert (column >= 0 && column < 4) : "column = " + column;
        assert (row >= 0 && row < 4) : "row = " + row;
        long matrixVa = this.va();
        Mat44.setElement(matrixVa, row, column, value);
    }

    public void setTranslation(Vec3Arg offset) {
        long matrixVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        Mat44.setTranslation(matrixVa, x, y, z);
    }

    public static Mat44 sIdentity() {
        long matrixVa = Mat44.createIdentity();
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotation(QuatArg rotation) {
        float rw = rotation.getW();
        float rx = rotation.getX();
        float ry = rotation.getY();
        float rz = rotation.getZ();
        long matrixVa = Mat44.createRotation(rx, ry, rz, rw);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotation(Vec3Arg axis, float angle) {
        float ax = axis.getX();
        float ay = axis.getY();
        float az = axis.getZ();
        long matrixVa = Mat44.createRotationAxisAngle(ax, ay, az, angle);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotationTranslation(QuatArg rotation, Vec3Arg offset) {
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        rotation.copyTo(floatBuffer);
        floatBuffer.put(4, offset.getX());
        floatBuffer.put(5, offset.getY());
        floatBuffer.put(6, offset.getZ());
        long matrixVa = Mat44.createRotationTranslation(floatBuffer);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotationX(float angle) {
        long matrixVa = Mat44.createRotationX(angle);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotationY(float angle) {
        long matrixVa = Mat44.createRotationY(angle);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sRotationZ(float angle) {
        long matrixVa = Mat44.createRotationZ(angle);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sScale(float factor) {
        long matrixVa = Mat44.createScale(factor, factor, factor);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sScale(Float3 factors) {
        float sx = factors.x;
        float sy = factors.y;
        float sz = factors.z;
        long matrixVa = Mat44.createScale(sx, sy, sz);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sScale(Vec3Arg factors) {
        float sx = factors.getX();
        float sy = factors.getY();
        float sz = factors.getZ();
        long matrixVa = Mat44.createScale(sx, sy, sz);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sTranslation(Vec3Arg offset) {
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        long matrixVa = Mat44.createTranslation(x, y, z);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    public static Mat44 sZero() {
        long matrixVa = Mat44.createZero();
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public Vec3 getAxisX() {
        long matrixVa = this.va();
        float x = Mat44.getElement(matrixVa, 0, 0);
        float y = Mat44.getElement(matrixVa, 1, 0);
        float z = Mat44.getElement(matrixVa, 2, 0);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getAxisY() {
        long matrixVa = this.va();
        float x = Mat44.getElement(matrixVa, 0, 1);
        float y = Mat44.getElement(matrixVa, 1, 1);
        float z = Mat44.getElement(matrixVa, 2, 1);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getAxisZ() {
        long matrixVa = this.va();
        float x = Mat44.getElement(matrixVa, 0, 2);
        float y = Mat44.getElement(matrixVa, 1, 2);
        float z = Mat44.getElement(matrixVa, 2, 2);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getDiagonal3() {
        long matrixVa = this.va();
        float x = Mat44.getElement(matrixVa, 0, 0);
        float y = Mat44.getElement(matrixVa, 1, 1);
        float z = Mat44.getElement(matrixVa, 2, 2);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public float getElement(int row, int column) {
        assert (column >= 0 && column < 4) : "column = " + column;
        assert (row >= 0 && row < 4) : "row = " + row;
        long matrixVa = this.va();
        float result = Mat44.getElement(matrixVa, row, column);
        return result;
    }

    @Override
    public Quat getQuaternion() {
        long matrixVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Mat44.getQuaternion(matrixVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public Vec3 getTranslation() {
        long matrixVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Mat44.getTranslation(matrixVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Mat44 inversed() {
        long currentVa = this.va();
        long resultVa = Mat44.inversed(currentVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public Mat44 inversed3x3() {
        long currentVa = this.va();
        long resultVa = Mat44.inversed3x3(currentVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public Mat44 inversedRotationTranslation() {
        long currentVa = this.va();
        long resultVa = Mat44.inversedRotationTranslation(currentVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public boolean isEqual(Mat44Arg m2) {
        long m1Va = this.va();
        long m2Va = m2.targetVa();
        boolean result = Mat44.equals(m1Va, m2Va);
        return result;
    }

    @Override
    public boolean isIdentity() {
        long matrixVa = this.va();
        boolean result = Mat44.isIdentity(matrixVa);
        return result;
    }

    @Override
    public Mat44 multiply(Mat44Arg right) {
        long leftVa = this.va();
        long rightVa = right.targetVa();
        long resultVa = Mat44.multiply(leftVa, rightVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public Mat44 multiply3x3(Mat44Arg right) {
        long leftVa = this.va();
        long rightVa = right.targetVa();
        long resultVa = Mat44.multiply3x3(leftVa, rightVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public Vec3 multiply3x3(Vec3Arg vec3Arg) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        vec3Arg.copyTo(floatBuffer);
        Mat44.multiply3x3(matrixVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public Vec3 multiply3x3Transposed(Vec3Arg vec3Arg) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        vec3Arg.copyTo(floatBuffer);
        Mat44.multiply3x3Transposed(matrixVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public Vec3 multiply3x4(Vec3Arg vec3Arg) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        vec3Arg.copyTo(floatBuffer);
        Mat44.multiply3x4(matrixVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public void multiply3x4InPlace(Vec3 storeVec) {
        long matrixVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        storeVec.copyTo(floatBuffer);
        Mat44.multiply3x4(matrixVa, floatBuffer);
        storeVec.set(floatBuffer);
    }

    @Override
    public Mat44 postTranslated(Vec3Arg vec3) {
        long matrixVa = this.va();
        float x = vec3.getX();
        float y = vec3.getY();
        float z = vec3.getZ();
        long resultVa = Mat44.postTranslated(matrixVa, x, y, z);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    @Override
    public void putColumnMajor(FloatBuffer storeFloats) {
        int position = storeFloats.position();
        long matrixVa = this.va();
        Mat44.putColumnMajor(matrixVa, position, storeFloats);
        storeFloats.position(position + 16);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("Mat44[");
        for (int rowIndex = 0; rowIndex < 4; ++rowIndex) {
            result.append("\n ");
            result.append(this.getElement(rowIndex, 0));
            result.append("  ");
            result.append(this.getElement(rowIndex, 1));
            result.append("  ");
            result.append(this.getElement(rowIndex, 2));
            result.append("  ");
            result.append(this.getElement(rowIndex, 3));
        }
        result.append("\n]");
        return result.toString();
    }

    private static native void assign(long var0, long var2);

    private static native long createCopy(long var0);

    private static native long createFromColumnMajor(float[] var0);

    private static native long createFromRMatrix(long var0);

    private static native long createIdentity();

    private static native long createRotation(float var0, float var1, float var2, float var3);

    private static native long createRotationAxisAngle(float var0, float var1, float var2, float var3);

    private static native long createRotationTranslation(FloatBuffer var0);

    private static native long createRotationX(float var0);

    private static native long createRotationY(float var0);

    private static native long createRotationZ(float var0);

    private static native long createScale(float var0, float var1, float var2);

    private static native long createTranslation(float var0, float var1, float var2);

    private static native long createUninitialized();

    private static native long createZero();

    private static native boolean equals(long var0, long var2);

    private static native void free(long var0);

    private static native float getElement(long var0, int var2, int var3);

    private static native void getQuaternion(long var0, FloatBuffer var2);

    private static native void getTranslation(long var0, FloatBuffer var2);

    private static native long inversed(long var0);

    private static native long inversed3x3(long var0);

    private static native long inversedRotationTranslation(long var0);

    private static native boolean isIdentity(long var0);

    private static native void leftMultiplyInPlace(long var0, long var2);

    private static native void loadIdentity(long var0);

    private static native long multiply(long var0, long var2);

    private static native long multiply3x3(long var0, long var2);

    private static native void multiply3x3(long var0, FloatBuffer var2);

    private static native void multiply3x3Transposed(long var0, FloatBuffer var2);

    private static native void multiply3x4(long var0, FloatBuffer var2);

    private static native long postTranslated(long var0, float var2, float var3, float var4);

    private static native void putColumnMajor(long var0, int var2, FloatBuffer var3);

    private static native void rightMultiplyInPlace(long var0, long var2);

    private static native void setAxisX(long var0, float var2, float var3, float var4);

    private static native void setAxisY(long var0, float var2, float var3, float var4);

    private static native void setAxisZ(long var0, float var2, float var3, float var4);

    private static native void setDiagonal3(long var0, float var2, float var3, float var4);

    private static native void setElement(long var0, int var2, int var3, float var4);

    private static native void setTranslation(long var0, float var2, float var3, float var4);
}

