/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.UVec4;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionQuality;
import com.github.stephengold.joltjni.readonly.ConstMassProperties;
import com.github.stephengold.joltjni.readonly.ConstMotionProperties;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class MotionProperties
extends JoltPhysicsObject
implements ConstMotionProperties {
    public MotionProperties() {
        long propertiesVa = MotionProperties.createDefault();
        this.setVirtualAddress(propertiesVa, () -> MotionProperties.free(propertiesVa));
    }

    MotionProperties(boolean dummy) {
    }

    public MotionProperties(ConstMotionProperties original) {
        long originalVa = original.targetVa();
        long copyVa = MotionProperties.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> MotionProperties.free(copyVa));
    }

    MotionProperties(JoltPhysicsObject container, long propertiesVa) {
        super(container, propertiesVa);
    }

    public void moveKinematic(Vec3Arg offset, QuatArg rotation, float deltaTime) {
        long propertiesVa = this.va();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        float qw = rotation.getW();
        float qx = rotation.getX();
        float qy = rotation.getY();
        float qz = rotation.getZ();
        MotionProperties.moveKinematic(propertiesVa, dx, dy, dz, qx, qy, qz, qw, deltaTime);
    }

    public void resetForce() {
        long propertiesVa = this.va();
        MotionProperties.resetForce(propertiesVa);
    }

    public void resetTorque() {
        long propertiesVa = this.va();
        MotionProperties.resetTorque(propertiesVa);
    }

    public void setAngularDamping(float damping) {
        long propertiesVa = this.va();
        MotionProperties.setAngularDamping(propertiesVa, damping);
    }

    public void setAngularVelocity(Vec3Arg omega) {
        long propertiesVa = this.va();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        MotionProperties.setAngularVelocity(propertiesVa, wx, wy, wz);
    }

    public void setGravityFactor(float factor) {
        long propertiesVa = this.va();
        MotionProperties.setGravityFactor(propertiesVa, factor);
    }

    public void setInverseInertia(Vec3Arg diagonal, QuatArg rotation) {
        long propertiesVa = this.va();
        float dx = diagonal.getX();
        float dy = diagonal.getY();
        float dz = diagonal.getZ();
        float rw = rotation.getW();
        float rx = rotation.getX();
        float ry = rotation.getY();
        float rz = rotation.getZ();
        MotionProperties.setInverseInertia(propertiesVa, dx, dy, dz, rx, ry, rz, rw);
    }

    public void setInverseMass(float inverseMass) {
        long propertiesVa = this.va();
        MotionProperties.setInverseMass(propertiesVa, inverseMass);
    }

    public void setLinearDamping(float damping) {
        long propertiesVa = this.va();
        MotionProperties.setLinearDamping(propertiesVa, damping);
    }

    public void setLinearVelocity(Vec3Arg velocity) {
        long propertiesVa = this.va();
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        MotionProperties.setLinearVelocity(propertiesVa, vx, vy, vz);
    }

    public void setMassProperties(int allowedDofs, ConstMassProperties massProperties) {
        long propertiesVa = this.va();
        long massPropsVa = massProperties.targetVa();
        MotionProperties.setMassProperties(propertiesVa, allowedDofs, massPropsVa);
    }

    public void setMaxAngularVelocity(float maxSpeed) {
        long propertiesVa = this.va();
        MotionProperties.setMaxAngularVelocity(propertiesVa, maxSpeed);
    }

    public void setMaxLinearVelocity(float maxSpeed) {
        long propertiesVa = this.va();
        MotionProperties.setMaxLinearVelocity(propertiesVa, maxSpeed);
    }

    public void setNumPositionStepsOverride(int numIterations) {
        long propertiesVa = this.va();
        MotionProperties.setNumPositionStepsOverride(propertiesVa, numIterations);
    }

    public void setNumVelocityStepsOverride(int numIterations) {
        long propertiesVa = this.va();
        MotionProperties.setNumVelocityStepsOverride(propertiesVa, numIterations);
    }

    @Override
    public Vec3 getAccumulatedForce() {
        long propertiesVa = this.va();
        float x = MotionProperties.getAccumulatedForceX(propertiesVa);
        float y = MotionProperties.getAccumulatedForceY(propertiesVa);
        float z = MotionProperties.getAccumulatedForceZ(propertiesVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public Vec3 getAccumulatedTorque() {
        long propertiesVa = this.va();
        float x = MotionProperties.getAccumulatedTorqueX(propertiesVa);
        float y = MotionProperties.getAccumulatedTorqueY(propertiesVa);
        float z = MotionProperties.getAccumulatedTorqueZ(propertiesVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    @Override
    public int getAllowedDofs() {
        long propertiesVa = this.va();
        int result = MotionProperties.getAllowedDofs(propertiesVa);
        return result;
    }

    @Override
    public boolean getAllowSleeping() {
        long propertiesVa = this.va();
        boolean result = MotionProperties.getAllowSleeping(propertiesVa);
        return result;
    }

    @Override
    public float getAngularDamping() {
        long propertiesVa = this.va();
        float result = MotionProperties.getAngularDamping(propertiesVa);
        return result;
    }

    @Override
    public UVec4 getAngularDofsMask() {
        long propertiesVa = this.va();
        int dofs = MotionProperties.getAllowedDofs(propertiesVa);
        UVec4 result = new UVec4();
        if ((dofs & 8) != 0) {
            result.setX(-1);
        }
        if ((dofs & 0x10) != 0) {
            result.setY(-1);
        }
        if ((dofs & 0x20) != 0) {
            result.setZ(-1);
        }
        return result;
    }

    @Override
    public Vec3 getAngularVelocity() {
        long propertiesVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        MotionProperties.getAngularVelocity(propertiesVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getGravityFactor() {
        long propertiesVa = this.va();
        float result = MotionProperties.getGravityFactor(propertiesVa);
        return result;
    }

    @Override
    public Quat getInertiaRotation() {
        long propertiesVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        MotionProperties.getInertiaRotation(propertiesVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public Vec3 getInverseInertiaDiagonal() {
        long propertiesVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        MotionProperties.getInverseInertiaDiagonal(propertiesVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getInverseMass() {
        long propertiesVa = this.va();
        float result = MotionProperties.getInverseMass(propertiesVa);
        return result;
    }

    @Override
    public float getInverseMassUnchecked() {
        long propertiesVa = this.va();
        float result = MotionProperties.getInverseMassUnchecked(propertiesVa);
        return result;
    }

    @Override
    public float getLinearDamping() {
        long propertiesVa = this.va();
        float result = MotionProperties.getLinearDamping(propertiesVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long propertiesVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        MotionProperties.getLinearVelocity(propertiesVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Mat44 getLocalSpaceInverseInertia() {
        long propertiesVa = this.va();
        long matrixVa = MotionProperties.getLocalSpaceInverseInertia(propertiesVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public float getMaxAngularVelocity() {
        long propertiesVa = this.va();
        float result = MotionProperties.getMaxAngularVelocity(propertiesVa);
        return result;
    }

    @Override
    public float getMaxLinearVelocity() {
        long propertiesVa = this.va();
        float result = MotionProperties.getMaxLinearVelocity(propertiesVa);
        return result;
    }

    @Override
    public EMotionQuality getMotionQuality() {
        long propertiesVa = this.va();
        int ordinal = MotionProperties.getMotionQuality(propertiesVa);
        EMotionQuality result = EMotionQuality.values()[ordinal];
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long propertiesVa = this.va();
        int result = MotionProperties.getNumPositionStepsOverride(propertiesVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long propertiesVa = this.va();
        int result = MotionProperties.getNumVelocityStepsOverride(propertiesVa);
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native float getAccumulatedForceX(long var0);

    private static native float getAccumulatedForceY(long var0);

    private static native float getAccumulatedForceZ(long var0);

    private static native float getAccumulatedTorqueX(long var0);

    private static native float getAccumulatedTorqueY(long var0);

    private static native float getAccumulatedTorqueZ(long var0);

    private static native int getAllowedDofs(long var0);

    private static native boolean getAllowSleeping(long var0);

    private static native float getAngularDamping(long var0);

    private static native void getAngularVelocity(long var0, FloatBuffer var2);

    private static native float getGravityFactor(long var0);

    private static native void getInertiaRotation(long var0, FloatBuffer var2);

    private static native void getInverseInertiaDiagonal(long var0, FloatBuffer var2);

    private static native float getInverseMass(long var0);

    private static native float getInverseMassUnchecked(long var0);

    private static native float getLinearDamping(long var0);

    private static native void getLinearVelocity(long var0, FloatBuffer var2);

    private static native long getLocalSpaceInverseInertia(long var0);

    private static native float getMaxAngularVelocity(long var0);

    private static native float getMaxLinearVelocity(long var0);

    private static native int getMotionQuality(long var0);

    private static native int getNumPositionStepsOverride(long var0);

    private static native int getNumVelocityStepsOverride(long var0);

    private static native void moveKinematic(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native void resetForce(long var0);

    private static native void resetTorque(long var0);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularVelocity(long var0, float var2, float var3, float var4);

    private static native void setGravityFactor(long var0, float var2);

    private static native void setInverseInertia(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private static native void setInverseMass(long var0, float var2);

    private static native void setLinearDamping(long var0, float var2);

    private static native void setLinearVelocity(long var0, float var2, float var3, float var4);

    private static native void setMassProperties(long var0, int var2, long var3);

    private static native void setMaxAngularVelocity(long var0, float var2);

    private static native void setMaxLinearVelocity(long var0, float var2);

    private static native void setNumPositionStepsOverride(long var0, int var2);

    private static native void setNumVelocityStepsOverride(long var0, int var2);
}

