/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.BodyActivationListener;
import com.github.stephengold.joltjni.BodyIdVector;
import com.github.stephengold.joltjni.BodyInterface;
import com.github.stephengold.joltjni.BodyLockInterfaceLocking;
import com.github.stephengold.joltjni.BodyLockInterfaceNoLock;
import com.github.stephengold.joltjni.BodyManagerDrawSettings;
import com.github.stephengold.joltjni.BroadPhaseQuery;
import com.github.stephengold.joltjni.CombineFunction;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.Constraints;
import com.github.stephengold.joltjni.ContactListener;
import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.DefaultBroadPhaseLayerFilter;
import com.github.stephengold.joltjni.DefaultObjectLayerFilter;
import com.github.stephengold.joltjni.JobSystem;
import com.github.stephengold.joltjni.NarrowPhaseQuery;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PhysicsSettings;
import com.github.stephengold.joltjni.PhysicsStepListener;
import com.github.stephengold.joltjni.SimCollideBodyVsBody;
import com.github.stephengold.joltjni.SimShapeFilter;
import com.github.stephengold.joltjni.SoftBodyContactListener;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.StateRecorderFilter;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintRef;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.VehicleConstraintRef;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceLocking;
import com.github.stephengold.joltjni.readonly.ConstBodyLockInterfaceNoLock;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseLayerInterface;
import com.github.stephengold.joltjni.readonly.ConstBroadPhaseQuery;
import com.github.stephengold.joltjni.readonly.ConstConstraint;
import com.github.stephengold.joltjni.readonly.ConstNarrowPhaseQuery;
import com.github.stephengold.joltjni.readonly.ConstObjectLayerPairFilter;
import com.github.stephengold.joltjni.readonly.ConstObjectVsBroadPhaseLayerFilter;
import com.github.stephengold.joltjni.readonly.ConstPhysicsSettings;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class PhysicsSystem
extends NonCopyable {
    private final BodyInterface bodyInterface;
    private final BodyInterface bodyInterfaceNoLock;
    private ConstBroadPhaseLayerInterface layerMap;
    private ConstObjectLayerPairFilter ovoFilter;
    private ConstObjectVsBroadPhaseLayerFilter ovbFilter;
    private ContactListener contactListener;
    private final Map<Long, PhysicsStepListener> stepListeners = new HashMap<Long, PhysicsStepListener>(16);
    private static final Map<Long, PhysicsSystem> va2ps = new HashMap<Long, PhysicsSystem>(32);
    private final ConstNarrowPhaseQuery narrowPhaseQuery;
    private final ConstNarrowPhaseQuery narrowQueryNoLock;
    private SimShapeFilter simShapeFilter;
    private SoftBodyContactListener softContactListener;

    public PhysicsSystem() {
        long systemVa = PhysicsSystem.createDefault();
        this.setVirtualAddressAsOwner(systemVa);
        va2ps.put(systemVa, this);
        long lockingVa = PhysicsSystem.getBodyInterface(systemVa);
        this.bodyInterface = new BodyInterface(this, lockingVa);
        long noLockVa = PhysicsSystem.getBodyInterfaceNoLock(systemVa);
        this.bodyInterfaceNoLock = new BodyInterface(this, noLockVa);
        lockingVa = PhysicsSystem.getNarrowPhaseQuery(systemVa);
        this.narrowPhaseQuery = new NarrowPhaseQuery(this, lockingVa);
        noLockVa = PhysicsSystem.getNarrowPhaseQueryNoLock(systemVa);
        this.narrowQueryNoLock = new NarrowPhaseQuery(this, noLockVa);
    }

    public void addConstraint(Constraint constraint) {
        long systemVa = this.va();
        long constraintVa = constraint.va();
        PhysicsSystem.addConstraint(systemVa, constraintVa);
    }

    public void addConstraint(TwoBodyConstraintRef constraintRef) {
        long systemVa = this.va();
        long constraintVa = constraintRef.targetVa();
        PhysicsSystem.addConstraint(systemVa, constraintVa);
    }

    public void addConstraint(VehicleConstraintRef constraintRef) {
        long systemVa = this.va();
        long constraintVa = constraintRef.targetVa();
        PhysicsSystem.addConstraint(systemVa, constraintVa);
    }

    public void addStepListener(PhysicsStepListener listener) {
        long systemVa = this.va();
        long listenerVa = listener.targetVa();
        this.stepListeners.put(listenerVa, listener);
        PhysicsSystem.addStepListener(systemVa, listenerVa);
    }

    public int destroyAllBodies() {
        long systemVa = this.va();
        int result = PhysicsSystem.destroyAllBodies(systemVa);
        return result;
    }

    public void drawBodies(BodyManagerDrawSettings settings, DebugRenderer renderer) {
        long systemVa = this.va();
        long settingsVa = settings.va();
        long rendererVa = renderer.va();
        PhysicsSystem.drawBodies(systemVa, settingsVa, rendererVa);
    }

    public void drawConstraints(DebugRenderer renderer) {
        long systemVa = this.va();
        long rendererVa = renderer.va();
        PhysicsSystem.drawConstraints(systemVa, rendererVa);
    }

    public void drawConstraintLimits(DebugRenderer renderer) {
        long systemVa = this.va();
        long rendererVa = renderer.va();
        PhysicsSystem.drawConstraintLimits(systemVa, rendererVa);
    }

    public void drawConstraintReferenceFrame(DebugRenderer renderer) {
        long systemVa = this.va();
        long rendererVa = renderer.va();
        PhysicsSystem.drawConstraintReferenceFrame(systemVa, rendererVa);
    }

    public boolean containsConstraint(ConstConstraint constraint) {
        long systemVa = this.va();
        long constraintVa = constraint.targetVa();
        boolean result = PhysicsSystem.containsConstraint(systemVa, constraintVa);
        return result;
    }

    public static PhysicsSystem find(long systemVa) {
        PhysicsSystem result = va2ps.get(systemVa);
        return result;
    }

    public void forgetMe() {
        long systemVa = this.va();
        va2ps.remove(systemVa);
    }

    public void getActiveBodies(EBodyType bodyType, BodyIdVector storeResult) {
        long systemVa = this.va();
        int ordinal = bodyType.ordinal();
        long vectorVa = storeResult.va();
        PhysicsSystem.getActiveBodies(systemVa, ordinal, vectorVa);
    }

    public void getBodies(BodyIdVector storeResult) {
        long systemVa = this.va();
        long resultVa = storeResult.va();
        PhysicsSystem.getBodies(systemVa, resultVa);
    }

    public BodyActivationListener getBodyActivationListener() {
        long systemVa = this.va();
        long listenerVa = PhysicsSystem.getBodyActivationListener(systemVa);
        BodyActivationListener result = listenerVa == 0L ? null : new BodyActivationListener(listenerVa);
        return result;
    }

    public BodyInterface getBodyInterface() {
        assert (this.bodyInterface != null);
        return this.bodyInterface;
    }

    public BodyInterface getBodyInterfaceNoLock() {
        assert (this.bodyInterfaceNoLock != null);
        return this.bodyInterfaceNoLock;
    }

    public ConstBodyLockInterfaceLocking getBodyLockInterface() {
        long systemVa = this.va();
        long interfaceVa = PhysicsSystem.getBodyLockInterface(systemVa);
        BodyLockInterfaceLocking result = new BodyLockInterfaceLocking(this, interfaceVa);
        return result;
    }

    public ConstBodyLockInterfaceNoLock getBodyLockInterfaceNoLock() {
        long systemVa = this.va();
        long interfaceVa = PhysicsSystem.getBodyLockInterfaceNoLock(systemVa);
        BodyLockInterfaceNoLock result = new BodyLockInterfaceNoLock(this, interfaceVa);
        return result;
    }

    public AaBox getBounds() {
        long systemVa = this.va();
        long boxVa = PhysicsSystem.getBounds(systemVa);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    public ConstBroadPhaseLayerInterface getBroadPhaseLayerInterface() {
        return this.layerMap;
    }

    public ConstBroadPhaseQuery getBroadPhaseQuery() {
        long systemVa = this.va();
        long broadVa = PhysicsSystem.getBroadPhaseQuery(systemVa);
        BroadPhaseQuery result = broadVa == 0L ? null : new BroadPhaseQuery(this, broadVa);
        return result;
    }

    public CombineFunction getCombineFriction() {
        long systemVa = this.va();
        long functionVa = PhysicsSystem.getCombineFriction(systemVa);
        CombineFunction result = new CombineFunction(functionVa);
        return result;
    }

    public CombineFunction getCombineRestitution() {
        long systemVa = this.va();
        long functionVa = PhysicsSystem.getCombineRestitution(systemVa);
        CombineFunction result = new CombineFunction(functionVa);
        return result;
    }

    public Constraints getConstraints() {
        long systemVa = this.va();
        long resultVa = PhysicsSystem.getConstraints(systemVa);
        Constraints result = new Constraints(resultVa, true);
        return result;
    }

    public ContactListener getContactListener() {
        return this.contactListener;
    }

    public DefaultBroadPhaseLayerFilter getDefaultBroadPhaseLayerFilter(int objectLayer) {
        DefaultBroadPhaseLayerFilter result = new DefaultBroadPhaseLayerFilter(this.ovbFilter, objectLayer);
        return result;
    }

    public DefaultObjectLayerFilter getDefaultLayerFilter(int objectLayer) {
        DefaultObjectLayerFilter result = new DefaultObjectLayerFilter(this.ovoFilter, objectLayer);
        return result;
    }

    public Vec3 getGravity() {
        long systemVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        PhysicsSystem.getGravity(systemVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public int getMaxBodies() {
        long systemVa = this.va();
        int result = PhysicsSystem.getMaxBodies(systemVa);
        return result;
    }

    public ConstNarrowPhaseQuery getNarrowPhaseQuery() {
        return this.narrowPhaseQuery;
    }

    public ConstNarrowPhaseQuery getNarrowPhaseQueryNoLock() {
        return this.narrowQueryNoLock;
    }

    public int getNumActiveBodies(EBodyType bodyType) {
        long systemVa = this.va();
        int typeOrdinal = bodyType.ordinal();
        int result = PhysicsSystem.getNumActiveBodies(systemVa, typeOrdinal);
        return result;
    }

    public int getNumBodies() {
        long systemVa = this.va();
        int result = PhysicsSystem.getNumBodies(systemVa);
        return result;
    }

    public ConstObjectLayerPairFilter getObjectLayerPairFilter() {
        return this.ovoFilter;
    }

    public ConstObjectVsBroadPhaseLayerFilter getObjectVsBroadPhaseLayerFilter() {
        return this.ovbFilter;
    }

    public PhysicsSettings getPhysicsSettings() {
        long systemVa = this.va();
        long settingsVa = PhysicsSystem.getPhysicsSettings(systemVa);
        PhysicsSettings result = new PhysicsSettings(settingsVa, true);
        return result;
    }

    public SoftBodyContactListener getSoftBodyContactListener() {
        return this.softContactListener;
    }

    public PhysicsSystem init(int maxBodies, int numBodyMutexes, int maxBodyPairs, int maxContactConstraints, ConstBroadPhaseLayerInterface map, ConstObjectVsBroadPhaseLayerFilter ovbFilter, ConstObjectLayerPairFilter ovoFilter) {
        this.layerMap = map;
        this.ovbFilter = ovbFilter;
        this.ovoFilter = ovoFilter;
        long systemVa = this.va();
        long mapVa = map.targetVa();
        long ovbFilterVa = ovbFilter.targetVa();
        long ovoFilterVa = ovoFilter.targetVa();
        PhysicsSystem.init(systemVa, maxBodies, numBodyMutexes, maxBodyPairs, maxContactConstraints, mapVa, ovbFilterVa, ovoFilterVa);
        return this;
    }

    public void optimizeBroadPhase() {
        PhysicsSystem.optimizeBroadPhase(this.va());
    }

    public int removeAllBodies() {
        long systemVa = this.va();
        int result = PhysicsSystem.removeAllBodies(systemVa);
        return result;
    }

    public int removeAllConstraints() {
        long systemVa = this.va();
        int result = PhysicsSystem.removeAllConstraints(systemVa);
        return result;
    }

    public void removeConstraint(Constraint constraint) {
        long systemVa = this.va();
        long constraintVa = constraint.va();
        PhysicsSystem.removeConstraint(systemVa, constraintVa);
    }

    public void removeStepListener(PhysicsStepListener listener) {
        long systemVa = this.va();
        long listenerVa = listener.targetVa();
        this.stepListeners.remove(listenerVa, listener);
        PhysicsSystem.removeStepListener(systemVa, listenerVa);
    }

    public boolean restoreState(StateRecorder recorder) {
        long systemVa = this.va();
        long recorderVa = recorder.va();
        boolean result = PhysicsSystem.restoreState(systemVa, recorderVa);
        return result;
    }

    public void saveState(StateRecorder recorder) {
        this.saveState(recorder, 15);
    }

    public void saveState(StateRecorder recorder, int bitmask) {
        this.saveState(recorder, bitmask, null);
    }

    public void saveState(StateRecorder recorder, int bitmask, StateRecorderFilter filter) {
        long systemVa = this.va();
        long recorderVa = recorder.va();
        long filterVa = filter == null ? 0L : filter.va();
        PhysicsSystem.saveState(systemVa, recorderVa, bitmask, filterVa);
    }

    public void setBodyActivationListener(BodyActivationListener listener) {
        long systemVa = this.va();
        long listenerVa = listener == null ? 0L : listener.va();
        PhysicsSystem.setBodyActivationListener(systemVa, listenerVa);
    }

    public void setCombineFriction(CombineFunction function) {
        long systemVa = this.va();
        long functionVa = function.va();
        PhysicsSystem.setCombineFriction(systemVa, functionVa);
    }

    public void setCombineRestitution(CombineFunction function) {
        long systemVa = this.va();
        long functionVa = function.va();
        PhysicsSystem.setCombineRestitution(systemVa, functionVa);
    }

    public void setContactListener(ContactListener listener) {
        this.contactListener = listener;
        long systemVa = this.va();
        long listenerVa = listener == null ? 0L : listener.va();
        PhysicsSystem.setContactListener(systemVa, listenerVa);
    }

    public void setGravity(float x, float y, float z) {
        long systemVa = this.va();
        PhysicsSystem.setGravity(systemVa, x, y, z);
    }

    public void setGravity(Vec3Arg gravity) {
        long systemVa = this.va();
        float x = gravity.getX();
        float y = gravity.getY();
        float z = gravity.getZ();
        PhysicsSystem.setGravity(systemVa, x, y, z);
    }

    public void setPhysicsSettings(ConstPhysicsSettings settings) {
        long systemVa = this.va();
        long settingsVa = settings.targetVa();
        PhysicsSystem.setPhysicsSettings(systemVa, settingsVa);
    }

    public void setSimCollideBodyVsBody(SimCollideBodyVsBody bodyVsBody) {
        long systemVa = this.va();
        long colliderVa = bodyVsBody.va();
        PhysicsSystem.setSimCollideBodyVsBody(systemVa, colliderVa);
    }

    public void setSimShapeFilter(SimShapeFilter shapeFilter) {
        this.simShapeFilter = shapeFilter;
        long systemVa = this.va();
        long filterVa = shapeFilter == null ? 0L : shapeFilter.va();
        PhysicsSystem.setSimShapeFilter(systemVa, filterVa);
    }

    public void setSoftBodyContactListener(SoftBodyContactListener listener) {
        this.softContactListener = listener;
        long systemVa = this.va();
        long listenerVa = listener == null ? 0L : listener.va();
        PhysicsSystem.setSoftBodyContactListener(systemVa, listenerVa);
    }

    public int update(float deltaTime, int collisionSteps, TempAllocator tempAllocator, JobSystem jobSystem) {
        long physicsSystemVa = this.va();
        long allocatorVa = tempAllocator.va();
        long jobSystemVa = jobSystem.va();
        int result = PhysicsSystem.update(physicsSystemVa, deltaTime, collisionSteps, allocatorVa, jobSystemVa);
        return result;
    }

    final void setVirtualAddressAsOwner(long systemVa) {
        Runnable freeingAction = () -> PhysicsSystem.free(systemVa);
        this.setVirtualAddress(systemVa, freeingAction);
    }

    private static native void addConstraint(long var0, long var2);

    private static native void addStepListener(long var0, long var2);

    private static native boolean containsConstraint(long var0, long var2);

    private static native long createDefault();

    private static native int destroyAllBodies(long var0);

    private static native void drawBodies(long var0, long var2, long var4);

    private static native void drawConstraints(long var0, long var2);

    private static native void drawConstraintLimits(long var0, long var2);

    private static native void drawConstraintReferenceFrame(long var0, long var2);

    private static native void free(long var0);

    private static native void getActiveBodies(long var0, int var2, long var3);

    private static native void getBodies(long var0, long var2);

    private static native long getBodyActivationListener(long var0);

    private static native long getBodyInterface(long var0);

    private static native long getBodyInterfaceNoLock(long var0);

    private static native long getBodyLockInterface(long var0);

    private static native long getBodyLockInterfaceNoLock(long var0);

    private static native long getBounds(long var0);

    private static native long getBroadPhaseQuery(long var0);

    private static native long getCombineFriction(long var0);

    private static native long getCombineRestitution(long var0);

    private static native long getConstraints(long var0);

    private static native void getGravity(long var0, FloatBuffer var2);

    private static native long getNarrowPhaseQuery(long var0);

    private static native long getNarrowPhaseQueryNoLock(long var0);

    private static native int getMaxBodies(long var0);

    private static native int getNumActiveBodies(long var0, int var2);

    private static native int getNumBodies(long var0);

    private static native long getPhysicsSettings(long var0);

    private static native void init(long var0, int var2, int var3, int var4, int var5, long var6, long var8, long var10);

    private static native void optimizeBroadPhase(long var0);

    private static native int removeAllBodies(long var0);

    private static native int removeAllConstraints(long var0);

    private static native void removeConstraint(long var0, long var2);

    private static native void removeStepListener(long var0, long var2);

    private static native boolean restoreState(long var0, long var2);

    private static native void saveState(long var0, long var2, int var4, long var5);

    private static native void setBodyActivationListener(long var0, long var2);

    private static native void setCombineFriction(long var0, long var2);

    private static native void setCombineRestitution(long var0, long var2);

    private static native void setContactListener(long var0, long var2);

    private static native void setGravity(long var0, float var2, float var3, float var4);

    private static native void setPhysicsSettings(long var0, long var2);

    private static native void setSimCollideBodyVsBody(long var0, long var2);

    private static native void setSimShapeFilter(long var0, long var2);

    private static native void setSoftBodyContactListener(long var0, long var2);

    private static native int update(long var0, float var2, int var3, long var4, long var6);
}

