/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.DecoratedShape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class ScaledShape
extends DecoratedShape {
    public ScaledShape(ConstShape baseShape, Vec3Arg scaleFactors) {
        long baseShapeVa = baseShape.targetVa();
        float scaleX = scaleFactors.getX();
        float scaleY = scaleFactors.getY();
        float scaleZ = scaleFactors.getZ();
        long scaledShapeVa = ScaledShape.createScaledShape(baseShapeVa, scaleX, scaleY, scaleZ);
        this.setVirtualAddressAsCoOwner(scaledShapeVa);
    }

    ScaledShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public Vec3 getScale() {
        long scaledVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ScaledShape.getScale(scaledVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createScaledShape(long var0, float var2, float var3, float var4);

    private static native void getScale(long var0, FloatBuffer var2);
}

