/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.template.Array;

public final class ShapeList
extends Array<ShapeRefC> {
    public ShapeList() {
        long listVa = ShapeList.createDefault();
        this.setVirtualAddress(listVa, () -> ShapeList.free(listVa));
    }

    public ShapeList(ShapeRefC shapeRef) {
        this();
        this.pushBack(shapeRef);
    }

    @Override
    public int capacity() {
        long listVa = this.va();
        int result = ShapeList.capacity(listVa);
        return result;
    }

    @Override
    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        ShapeList.erase(vectorVa, startIndex, stopIndex);
    }

    @Override
    public ShapeRefC get(int elementIndex) {
        long listVa = this.va();
        long shapeVa = ShapeList.getShapeRefC(listVa, elementIndex);
        ShapeRefC result = new ShapeRefC(shapeVa, true);
        return result;
    }

    @Override
    public void resize(int numElements) {
        long listVa = this.va();
        ShapeList.resize(listVa, numElements);
    }

    @Override
    public void set(int elementIndex, ShapeRefC shapeRef) {
        long listVa = this.va();
        long refVa = shapeRef.va();
        ShapeList.setShapeRefC(listVa, elementIndex, refVa);
    }

    @Override
    public int size() {
        long listVa = this.va();
        int result = ShapeList.size(listVa);
        return result;
    }

    private static native int capacity(long var0);

    private static native long createDefault();

    private static native void erase(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native long getShapeRefC(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void setShapeRefC(long var0, int var2, long var3);

    private static native int size(long var0);
}

