/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.template.Ref;

public final class ShapeRef
extends Ref {
    public ShapeRef() {
        long refVa = ShapeRef.createDefault();
        this.setVirtualAddress(refVa, () -> ShapeRef.free(refVa));
    }

    ShapeRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ShapeRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public Shape getPtr() {
        long shapeVa = this.targetVa();
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = ShapeRef.getPtr(refVa);
        return result;
    }

    @Override
    public ShapeRef toRef() {
        long refVa = this.va();
        long copyVa = ShapeRef.copy(refVa);
        ShapeRef result = new ShapeRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

