/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.MassProperties;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.Stats;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.enumerate.EShapeType;
import com.github.stephengold.joltjni.readonly.ConstColor;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public final class ShapeRefC
extends JoltPhysicsObject
implements ConstShape {
    public ShapeRefC() {
        long refVa = ShapeRefC.createDefault();
        this.setVirtualAddress(refVa, () -> ShapeRefC.free(refVa));
    }

    ShapeRefC(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ShapeRefC.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public ConstShape getPtr() {
        long shapeVa = this.targetVa();
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public void copyDebugTriangles(FloatBuffer storeBuffer) {
        long shapeVa = this.targetVa();
        int numTriangles = storeBuffer.capacity() / 9;
        Shape.copyDebugTriangles(shapeVa, numTriangles, storeBuffer);
    }

    @Override
    public int countDebugTriangles() {
        long shapeVa = this.targetVa();
        int result = Shape.countDebugTriangles(shapeVa);
        assert (result > 0) : "result = " + result;
        return result;
    }

    @Override
    public void draw(DebugRenderer renderer, RMat44Arg comTransform, Vec3Arg scale, ConstColor color, boolean useMaterialColors, boolean wireframe) {
        long shapeVa = this.targetVa();
        long rendererVa = renderer.va();
        long transformVa = comTransform.targetVa();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        int colorInt = color.getUInt32();
        Shape.draw(shapeVa, rendererVa, transformVa, scaleX, scaleY, scaleZ, colorInt, useMaterialColors, wireframe);
    }

    @Override
    public void drawGetSupportFunction(DebugRenderer renderer, RMat44Arg comTransform, Vec3Arg scale, ConstColor color, boolean drawSupportDirection) {
        long shapeVa = this.targetVa();
        long rendererVa = renderer.va();
        long transformVa = comTransform.targetVa();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        int colorInt = color.getUInt32();
        Shape.drawGetSupportFunction(shapeVa, rendererVa, transformVa, scaleX, scaleY, scaleZ, colorInt, drawSupportDirection);
    }

    @Override
    public Vec3 getCenterOfMass() {
        long shapeVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Shape.getCenterOfMass(shapeVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getInnerRadius() {
        long shapeVa = this.targetVa();
        float result = Shape.getInnerRadius(shapeVa);
        return result;
    }

    @Override
    public ConstShape getLeafShape(int subShapeId, int[] storeRemainderId) {
        long currentVa = this.targetVa();
        long leafVa = Shape.getLeafShape(currentVa, subShapeId, storeRemainderId);
        Shape result = Shape.newShape(leafVa);
        return result;
    }

    @Override
    public AaBox getLocalBounds() {
        long shapeVa = this.targetVa();
        long boxVa = Shape.getLocalBounds(shapeVa);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public MassProperties getMassProperties() {
        long shapeVa = this.targetVa();
        long propertiesVa = Shape.getMassProperties(shapeVa);
        MassProperties result = new MassProperties(propertiesVa, true);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getMaterial(int subShapeId) {
        long shapeVa = this.targetVa();
        long materialVa = Shape.getMaterial(shapeVa, subShapeId);
        PhysicsMaterial result = new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long shapeVa = this.targetVa();
        int result = Shape.getRefCount(shapeVa);
        return result;
    }

    @Override
    public long getRevisionCount() {
        long shapeVa = this.targetVa();
        long result = Shape.getUserData(shapeVa);
        return result;
    }

    @Override
    public Stats getStats() {
        long shapeVa = this.targetVa();
        long statsVa = Shape.getStats(shapeVa);
        Stats result = new Stats(statsVa, true);
        return result;
    }

    @Override
    public int getSubShapeIdBitsRecursive() {
        long shapeVa = this.targetVa();
        int result = Shape.getSubShapeIdBitsRecursive(shapeVa);
        return result;
    }

    @Override
    public EShapeSubType getSubType() {
        long shapeVa = this.targetVa();
        int ordinal = Shape.getSubType(shapeVa);
        EShapeSubType result = EShapeSubType.values()[ordinal];
        return result;
    }

    @Override
    public EShapeType getType() {
        long shapeVa = this.targetVa();
        int ordinal = Shape.getType(shapeVa);
        EShapeType result = EShapeType.values()[ordinal];
        return result;
    }

    @Override
    public AaBox getWorldSpaceBounds(Mat44Arg comTransform, Vec3Arg scale) {
        long shapeVa = this.targetVa();
        long matrixVa = comTransform.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long boxVa = Shape.getWorldSpaceBounds(shapeVa, matrixVa, sx, sy, sz);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public AaBox getWorldSpaceBounds(RMat44Arg comTransform, Vec3Arg scale) {
        long shapeVa = this.targetVa();
        long rMat44Va = comTransform.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long boxVa = Shape.getWorldSpaceBoundsReal(shapeVa, rMat44Va, sx, sy, sz);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public boolean isValidScale(Vec3Arg scale) {
        long shapeVa = this.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        boolean result = Shape.isValidScale(shapeVa, sx, sy, sz);
        return result;
    }

    @Override
    public Vec3 makeScaleValid(Vec3Arg scale) {
        long shapeVa = this.targetVa();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        scale.copyTo(floatBuffer);
        Shape.makeScaleValid(shapeVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public boolean mustBeStatic() {
        long shapeVa = this.targetVa();
        boolean result = Shape.mustBeStatic(shapeVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long shapeVa = this.targetVa();
        long streamVa = stream.va();
        Shape.saveBinaryState(shapeVa, streamVa);
    }

    @Override
    public ShapeResult scaleShape(Vec3Arg scaleFactors) {
        long shapeVa = this.targetVa();
        float sx = scaleFactors.getX();
        float sy = scaleFactors.getY();
        float sz = scaleFactors.getZ();
        long resultVa = Shape.scaleShape(shapeVa, sx, sy, sz);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = ShapeRefC.getPtr(refVa);
        return result;
    }

    @Override
    public ShapeRefC toRefC() {
        long refVa = this.va();
        long copyVa = ShapeRefC.copy(refVa);
        ShapeRefC result = new ShapeRefC(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

