/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class SliderConstraintSettings
extends TwoBodyConstraintSettings {
    public SliderConstraintSettings() {
        long settingsVa = SliderConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Slider);
    }

    SliderConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Slider);
    }

    public SliderConstraintSettings(SliderConstraintSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SliderConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Slider);
    }

    public boolean getAutoDetectPoint() {
        long settingsVa = this.va();
        boolean result = SliderConstraintSettings.getAutoDetectPoint(settingsVa);
        return result;
    }

    public float getLimitsMax() {
        long settingsVa = this.va();
        float result = SliderConstraintSettings.getLimitsMax(settingsVa);
        return result;
    }

    public float getLimitsMin() {
        long settingsVa = this.va();
        float result = SliderConstraintSettings.getLimitsMin(settingsVa);
        return result;
    }

    public SpringSettings getLimitsSpringSettings() {
        long constraintSettingsVa = this.va();
        long springSettingsVa = SliderConstraintSettings.getLimitsSpringSettings(constraintSettingsVa);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    public float getMaxFrictionForce() {
        long settingsVa = this.va();
        float result = SliderConstraintSettings.getMaxFrictionForce(settingsVa);
        return result;
    }

    public MotorSettings getMotorSettings() {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = SliderConstraintSettings.getMotorSettings(constraintSettingsVa);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public Vec3 getNormalAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SliderConstraintSettings.getNormalAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getNormalAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SliderConstraintSettings.getNormalAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SliderConstraintSettings.getPoint1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SliderConstraintSettings.getPoint2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public Vec3 getSliderAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SliderConstraintSettings.getSliderAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getSliderAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SliderConstraintSettings.getSliderAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = SliderConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setAutoDetectPoint(boolean setting) {
        long settingsVa = this.va();
        SliderConstraintSettings.setAutoDetectPoint(settingsVa, setting);
    }

    public void setLimitsMax(float limit) {
        long settingsVa = this.va();
        SliderConstraintSettings.setLimitsMax(settingsVa, limit);
    }

    public void setLimitsMin(float limit) {
        long settingsVa = this.va();
        SliderConstraintSettings.setLimitsMin(settingsVa, limit);
    }

    public void setMaxFrictionForce(float force) {
        long settingsVa = this.va();
        SliderConstraintSettings.setMaxFrictionForce(settingsVa, force);
    }

    public Vec3Arg setNormalAxis1(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        SliderConstraintSettings.setNormalAxis1(settingsVa, x, y, z);
        return direction;
    }

    public Vec3Arg setNormalAxis2(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        SliderConstraintSettings.setNormalAxis2(settingsVa, x, y, z);
        return direction;
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        SliderConstraintSettings.setPoint1(settingsVa, x, y, z);
        return location;
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        SliderConstraintSettings.setPoint2(settingsVa, x, y, z);
        return location;
    }

    public void setSliderAxis(Vec3Arg sliderAxis) {
        long settingsVa = this.va();
        float dx = sliderAxis.getX();
        float dy = sliderAxis.getY();
        float dz = sliderAxis.getZ();
        SliderConstraintSettings.setSliderAxis(settingsVa, dx, dy, dz);
    }

    public Vec3Arg setSliderAxis1(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        SliderConstraintSettings.setSliderAxis1(settingsVa, x, y, z);
        return direction;
    }

    public Vec3Arg setSliderAxis2(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        SliderConstraintSettings.setSliderAxis2(settingsVa, x, y, z);
        return direction;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        SliderConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native boolean getAutoDetectPoint(long var0);

    private static native float getLimitsMax(long var0);

    private static native float getLimitsMin(long var0);

    private static native long getLimitsSpringSettings(long var0);

    private static native float getMaxFrictionForce(long var0);

    private static native long getMotorSettings(long var0);

    private static native void getNormalAxis1(long var0, FloatBuffer var2);

    private static native void getNormalAxis2(long var0, FloatBuffer var2);

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native void getSliderAxis1(long var0, FloatBuffer var2);

    private static native void getSliderAxis2(long var0, FloatBuffer var2);

    private static native int getSpace(long var0);

    private static native void setAutoDetectPoint(long var0, boolean var2);

    private static native void setLimitsMax(long var0, float var2);

    private static native void setLimitsMin(long var0, float var2);

    private static native void setMaxFrictionForce(long var0, float var2);

    private static native void setNormalAxis1(long var0, float var2, float var3, float var4);

    private static native void setNormalAxis2(long var0, float var2, float var3, float var4);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSliderAxis(long var0, float var2, float var3, float var4);

    private static native void setSliderAxis1(long var0, float var2, float var3, float var4);

    private static native void setSliderAxis2(long var0, float var2, float var3, float var4);

    private static native void setSpace(long var0, int var2);
}

