/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Float3;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstSphere;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class Sphere
extends JoltPhysicsObject
implements ConstSphere {
    public Sphere() {
        long sphereVa = Sphere.createDefault();
        this.setVirtualAddress(sphereVa, () -> Sphere.free(sphereVa));
    }

    public Sphere(ConstSphere original) {
        long originalVa = original.targetVa();
        long copyVa = Sphere.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> Sphere.free(copyVa));
    }

    public Sphere(Float3 center, float radius) {
        long sphereVa = Sphere.create(center.x, center.y, center.z, radius);
        this.setVirtualAddress(sphereVa, () -> Sphere.free(sphereVa));
    }

    public Sphere(Vec3Arg center, float radius) {
        float x = center.getX();
        float y = center.getY();
        float z = center.getZ();
        long sphereVa = Sphere.create(x, y, z, radius);
        this.setVirtualAddress(sphereVa, () -> Sphere.free(sphereVa));
    }

    public void encapsulatePoint(Vec3Arg point) {
        long sphereVa = this.va();
        float x = point.getX();
        float y = point.getY();
        float z = point.getZ();
        Sphere.encapsulatePoint(sphereVa, x, y, z);
    }

    @Override
    public Vec3 getCenter() {
        long sphereVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Sphere.getCenter(sphereVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getRadius() {
        long sphereVa = this.va();
        float result = Sphere.getRadius(sphereVa);
        return result;
    }

    @Override
    public Vec3 getSupport(Vec3Arg direction) {
        long sphereVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Sphere.getSupport(sphereVa, dx, dy, dz, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long create(float var0, float var1, float var2, float var3);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void encapsulatePoint(long var0, float var2, float var3, float var4);

    private static native void free(long var0);

    private static native void getCenter(long var0, FloatBuffer var2);

    private static native float getRadius(long var0);

    private static native void getSupport(long var0, float var2, float var3, float var4, FloatBuffer var5);
}

