/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Body;
import com.github.stephengold.joltjni.Constraint;
import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.template.Ref;

public final class TwoBodyConstraintSettingsRef
extends Ref {
    public TwoBodyConstraintSettingsRef() {
        long refVa = TwoBodyConstraintSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> TwoBodyConstraintSettingsRef.free(refVa));
    }

    TwoBodyConstraintSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> TwoBodyConstraintSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public TwoBodyConstraint create(Body rigidBody1, Body rigidBody2) {
        long settingsVa = this.targetVa();
        long body1Va = rigidBody1.va();
        assert (!Body.isSoftBody(body1Va)) : "body1 must be a rigid body.";
        long body2Va = rigidBody2.va();
        assert (!Body.isSoftBody(body2Va)) : "body2 must be a rigid body.";
        long constraintVa = TwoBodyConstraintSettings.createConstraint(settingsVa, body1Va, body2Va);
        TwoBodyConstraint result = (TwoBodyConstraint)Constraint.newConstraint(constraintVa);
        return result;
    }

    @Override
    public TwoBodyConstraintSettings getPtr() {
        long settingsVa = this.targetVa();
        TwoBodyConstraintSettings result = (TwoBodyConstraintSettings)ConstraintSettings.newConstraintSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = TwoBodyConstraintSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public TwoBodyConstraintSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = TwoBodyConstraintSettingsRef.copy(refVa);
        TwoBodyConstraintSettingsRef result = new TwoBodyConstraintSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getPtr(long var0);
}

