/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.block;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.xmx.velthoric.builtin.block.BlockRigidBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import org.joml.Quaternionf;

public class BlockRenderer
extends VxRigidBodyRenderer<BlockRigidBody> {
    private BlockEntity cachedBlockEntity;
    private BlockState lastBlockState;

    @Override
    public void render(BlockRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        Block blockColors;
        int blockStateId = body.getSyncData(BlockRigidBody.DATA_BLOCK_STATE_ID);
        BlockState blockStateToRender = Block.stateById((int)blockStateId);
        if (blockStateToRender.isAir() || blockStateToRender.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        poseStack.pushPose();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.translate(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.mulPose(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        RenderShape shape = blockStateToRender.getRenderShape();
        if (shape == RenderShape.MODEL || shape == RenderShape.ENTITYBLOCK_ANIMATED) {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            blockColors = Minecraft.getInstance().getBlockColors();
            ClientLevel level = Minecraft.getInstance().level;
            BlockPos currentPos = BlockPos.containing((double)renderPosition.x(), (double)renderPosition.y(), (double)renderPosition.z());
            int color = blockColors.getColor(blockStateToRender, (BlockAndTintGetter)level, currentPos, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.5);
            dispatcher.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)blockStateToRender, (boolean)false)), blockStateToRender, dispatcher.getBlockModel(blockStateToRender), r, g, b, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if ((blockColors = blockStateToRender.getBlock()) instanceof EntityBlock) {
            BlockEntityRenderDispatcher beDispatcher;
            BlockEntityRenderer renderer;
            EntityBlock entityBlock = (EntityBlock)blockColors;
            if (this.lastBlockState != blockStateToRender) {
                this.cachedBlockEntity = entityBlock.newBlockEntity(BlockPos.ZERO, blockStateToRender);
                this.lastBlockState = blockStateToRender;
                if (this.cachedBlockEntity != null) {
                    this.cachedBlockEntity.setLevel((Level)Minecraft.getInstance().level);
                }
            }
            if (this.cachedBlockEntity != null && (renderer = (beDispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher()).getRenderer(this.cachedBlockEntity)) != null) {
                poseStack.pushPose();
                poseStack.translate(-0.5, -0.5, -0.5);
                renderer.render(this.cachedBlockEntity, partialTicks, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        } else {
            this.cachedBlockEntity = null;
            this.lastBlockState = null;
        }
        poseStack.popPose();
    }
}

