/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.block;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.MutableCompoundShapeSettings;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.xmx.velthoric.init.VxMainClass;
import net.xmx.velthoric.network.VxByteBuf;
import net.xmx.velthoric.physics.body.registry.VxBodyType;
import net.xmx.velthoric.physics.body.sync.VxDataAccessor;
import net.xmx.velthoric.physics.body.sync.VxDataSerializers;
import net.xmx.velthoric.physics.body.sync.VxSynchronizedData;
import net.xmx.velthoric.physics.body.type.VxRigidBody;
import net.xmx.velthoric.physics.body.type.factory.VxRigidBodyFactory;
import net.xmx.velthoric.physics.body.util.VxVoxelShapeUtil;
import net.xmx.velthoric.physics.world.VxPhysicsWorld;

public class BlockRigidBody
extends VxRigidBody {
    public static final VxDataAccessor<Integer> DATA_BLOCK_STATE_ID = VxDataAccessor.create(BlockRigidBody.class, VxDataSerializers.INTEGER);

    public BlockRigidBody(VxBodyType<BlockRigidBody> type, VxPhysicsWorld world, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, world, id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRigidBody(VxBodyType<BlockRigidBody> type, UUID id) {
        super((VxBodyType<? extends VxRigidBody>)type, id);
    }

    @Override
    protected void defineSyncData(VxSynchronizedData.Builder builder) {
        builder.define(DATA_BLOCK_STATE_ID, Block.getId((BlockState)Blocks.STONE.defaultBlockState()));
    }

    public void setRepresentedBlockState(BlockState blockState) {
        BlockState state = blockState != null && !blockState.isAir() ? blockState : Blocks.STONE.defaultBlockState();
        this.setSyncData(DATA_BLOCK_STATE_ID, Block.getId((BlockState)state));
    }

    public BlockState getRepresentedBlockState() {
        BlockState state = Block.stateById((int)this.getSyncData(DATA_BLOCK_STATE_ID));
        return !state.isAir() ? state : Blocks.STONE.defaultBlockState();
    }

    @Override
    public int createJoltBody(VxRigidBodyFactory factory) {
        int n;
        BlockState stateForShape = this.getRepresentedBlockState();
        VoxelShape voxelShape = stateForShape.getCollisionShape((BlockGetter)this.physicsWorld.getLevel(), BlockPos.ZERO);
        MutableCompoundShapeSettings shapeSettings = VxVoxelShapeUtil.toMutableCompoundShape(voxelShape);
        if (shapeSettings == null) {
            VxMainClass.LOGGER.warn("VoxelShape conversion for BlockState {} failed. Using default BoxShape.", (Object)stateForShape);
            try (MutableCompoundShapeSettings boxSettings = VxVoxelShapeUtil.toMutableCompoundShape(Blocks.STONE.defaultBlockState().getCollisionShape((BlockGetter)this.physicsWorld.getLevel(), BlockPos.ZERO));){
                int n2;
                try (BodyCreationSettings bcs = new BodyCreationSettings();){
                    bcs.setMotionType(EMotionType.Dynamic);
                    bcs.setObjectLayer(1);
                    n2 = factory.create(boxSettings, bcs);
                }
                return n2;
            }
        }
        try (BodyCreationSettings bcs = new BodyCreationSettings();){
            bcs.setMotionType(EMotionType.Dynamic);
            bcs.setObjectLayer(1);
            n = factory.create(shapeSettings, bcs);
        }
        return n;
        finally {
            if (shapeSettings != null) {
                shapeSettings.close();
            }
        }
    }

    @Override
    public void writePersistenceData(VxByteBuf buf) {
        buf.writeVarInt(this.getSyncData(DATA_BLOCK_STATE_ID));
    }

    @Override
    public void readPersistenceData(VxByteBuf buf) {
        int blockStateId = buf.readVarInt();
        BlockState state = Block.stateById((int)blockStateId);
        if (state.isAir()) {
            this.setSyncData(DATA_BLOCK_STATE_ID, Block.getId((BlockState)Blocks.STONE.defaultBlockState()));
        } else {
            this.setSyncData(DATA_BLOCK_STATE_ID, blockStateId);
        }
    }
}

