/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.xmx.velthoric.builtin.cloth.ClothSoftBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxSoftBodyRenderer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClothRenderer
extends VxSoftBodyRenderer<ClothSoftBody> {
    private static final ResourceLocation BLUE_WOOL_TEXTURE = ResourceLocation.tryParse((String)"minecraft:block/blue_wool");

    @Override
    public void render(ClothSoftBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        float[] renderVertexData = renderState.vertexData;
        int widthSegments = body.getSyncData(ClothSoftBody.DATA_WIDTH_SEGMENTS);
        int heightSegments = body.getSyncData(ClothSoftBody.DATA_HEIGHT_SEGMENTS);
        if (renderVertexData == null || renderVertexData.length < 12 || widthSegments <= 0 || heightSegments <= 0) {
            return;
        }
        int numVerticesX = widthSegments + 1;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.translucent());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(BLUE_WOOL_TEXTURE);
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        float deltaU = maxU - minU;
        float deltaV = maxV - minV;
        BiFunction<Integer, Integer, Vector3f> getVertexWorldPos = (x, y) -> {
            int index = (y * numVerticesX + x) * 3;
            if (index + 2 >= renderVertexData.length) {
                return new Vector3f();
            }
            return new Vector3f(renderVertexData[index], renderVertexData[index + 1], renderVertexData[index + 2]);
        };
        for (int y2 = 0; y2 < heightSegments; ++y2) {
            for (int x2 = 0; x2 < widthSegments; ++x2) {
                Vector3f edge2;
                Vector3f v1 = getVertexWorldPos.apply(x2, y2);
                Vector3f v2 = getVertexWorldPos.apply(x2 + 1, y2);
                Vector3f v3 = getVertexWorldPos.apply(x2 + 1, y2 + 1);
                Vector3f v4 = getVertexWorldPos.apply(x2, y2 + 1);
                float u1 = minU + deltaU * ((float)x2 / (float)widthSegments);
                float u2 = minU + deltaU * ((float)(x2 + 1) / (float)widthSegments);
                float v1Coord = minV + deltaV * ((float)y2 / (float)heightSegments);
                float v2Coord = minV + deltaV * ((float)(y2 + 1) / (float)heightSegments);
                Vector3f edge1 = new Vector3f((Vector3fc)v2).sub((Vector3fc)v1);
                Vector3f normal = edge1.cross((Vector3fc)(edge2 = new Vector3f((Vector3fc)v4).sub((Vector3fc)v1))).normalize();
                if (Float.isNaN(normal.x())) {
                    normal.set(0.0f, 1.0f, 0.0f);
                }
                this.addVertex(buffer, poseStack, v1, u1, v1Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v2, u2, v1Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v3, u2, v2Coord, normal, packedLight);
                this.addVertex(buffer, poseStack, v4, u1, v2Coord, normal, packedLight);
                Vector3f backNormal = new Vector3f((Vector3fc)normal).mul(-1.0f);
                this.addVertex(buffer, poseStack, v1, u1, v1Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v4, u1, v2Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v3, u2, v2Coord, backNormal, packedLight);
                this.addVertex(buffer, poseStack, v2, u2, v1Coord, backNormal, packedLight);
            }
        }
    }

    private void addVertex(VertexConsumer buffer, PoseStack poseStack, Vector3f pos, float u, float v, Vector3f normal, int packedLight) {
        buffer.addVertex(poseStack.last(), pos.x(), pos.y(), pos.z()).setColor(255, 255, 255, 255).setUv(u, v).setLight(packedLight).setNormal(poseStack.last(), normal.x(), normal.y(), normal.z());
    }
}

