/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.drivable.motorcycle;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.WheelSettingsWv;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import net.xmx.velthoric.physics.vehicle.type.motorcycle.VxMotorcycle;
import net.xmx.velthoric.physics.vehicle.wheel.VxWheelRenderState;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MotorcycleRenderer
extends VxRigidBodyRenderer<VxMotorcycle> {
    private static final BlockState CHASSIS_STATE = Blocks.RED_CONCRETE.defaultBlockState();
    private static final BlockState WHEEL_STATE = Blocks.BLACK_CONCRETE.defaultBlockState();

    @Override
    public void render(VxMotorcycle body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.pushPose();
        RVec3 renderPosition = renderState.transform.getTranslation();
        Quat renderRotation = renderState.transform.getRotation();
        poseStack.translate(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.mulPose(new Quaternionf(renderRotation.getX(), renderRotation.getY(), renderRotation.getZ(), renderRotation.getW()));
        Vec3 halfExtents = body.getChassisHalfExtents();
        poseStack.pushPose();
        poseStack.translate(-halfExtents.getX(), -halfExtents.getY(), -halfExtents.getZ());
        poseStack.scale(halfExtents.getX() * 2.0f, halfExtents.getY() * 2.0f, halfExtents.getZ() * 2.0f);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(CHASSIS_STATE, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        List<WheelSettingsWv> wheelSettingsList = body.getWheelSettings();
        List<VxWheelRenderState> wheelRenderStates = body.getInterpolatedWheelStates();
        if (wheelRenderStates == null || wheelSettingsList.size() != wheelRenderStates.size()) {
            poseStack.popPose();
            return;
        }
        for (int i = 0; i < wheelSettingsList.size(); ++i) {
            WheelSettingsWv wheelSettings = wheelSettingsList.get(i);
            VxWheelRenderState wheelState = wheelRenderStates.get(i);
            if (wheelState == null) continue;
            poseStack.pushPose();
            Vec3 attachmentPos = wheelSettings.getPosition();
            poseStack.translate(attachmentPos.getX(), attachmentPos.getY(), attachmentPos.getZ());
            Vec3 suspensionDir = wheelSettings.getSuspensionDirection();
            poseStack.translate(suspensionDir.getX() * wheelState.suspensionLength(), suspensionDir.getY() * wheelState.suspensionLength(), suspensionDir.getZ() * wheelState.suspensionLength());
            Vec3 steerAxis = wheelSettings.getSteeringAxis();
            poseStack.mulPose(Axis.of((Vector3f)new Vector3f(steerAxis.getX(), steerAxis.getY(), steerAxis.getZ())).rotation(wheelState.steerAngle()));
            poseStack.mulPose(Axis.XP.rotation(wheelState.rotationAngle()));
            float radius = wheelSettings.getRadius();
            float width = wheelSettings.getWidth();
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            poseStack.translate(-radius, -width / 2.0f, -radius);
            poseStack.scale(radius * 2.0f, width, radius * 2.0f);
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(WHEEL_STATE, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

