/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.marble;

import com.github.stephengold.joltjni.RVec3;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.xmx.velthoric.builtin.marble.MarbleRigidBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxRigidBodyRenderer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MarbleRenderer
extends VxRigidBodyRenderer<MarbleRigidBody> {
    private static final ItemStack MARBLE_ITEM_STACK = new ItemStack((ItemLike)Items.MAGMA_CREAM);

    @Override
    public void render(MarbleRigidBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        poseStack.pushPose();
        float radius = body.getSyncData(MarbleRigidBody.DATA_RADIUS).floatValue();
        RVec3 renderPosition = renderState.transform.getTranslation();
        poseStack.translate(renderPosition.x(), renderPosition.y(), renderPosition.z());
        poseStack.mulPose(Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        BakedModel itemModel = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(MARBLE_ITEM_STACK);
        TextureAtlasSprite sprite = itemModel.getParticleIcon();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        Matrix4f matrix4f = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        this.addVertex(vertexConsumer, matrix4f, matrix3f, -radius, -radius, sprite.getU0(), sprite.getV1(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, radius, -radius, sprite.getU1(), sprite.getV1(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, radius, radius, sprite.getU1(), sprite.getV0(), packedLight);
        this.addVertex(vertexConsumer, matrix4f, matrix3f, -radius, radius, sprite.getU0(), sprite.getV0(), packedLight);
        poseStack.popPose();
    }

    private void addVertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normalMatrix, float x, float y, float u, float v, int packedLight) {
        float nx = normalMatrix.m10;
        float ny = normalMatrix.m11;
        float nz = normalMatrix.m12;
        consumer.addVertex(pose, x, y, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(nx, ny, nz);
    }
}

