/*
 * Decompiled with CFR 0.152.
 */
package net.xmx.velthoric.builtin.rope;

import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.operator.Op;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.xmx.velthoric.builtin.rope.RopeSoftBody;
import net.xmx.velthoric.physics.body.client.VxRenderState;
import net.xmx.velthoric.physics.body.client.body.renderer.VxSoftBodyRenderer;

public class RopeRenderer
extends VxSoftBodyRenderer<RopeSoftBody> {
    private static final ResourceLocation YELLOW_WOOL_BLOCK_TEXTURE = ResourceLocation.tryParse((String)"minecraft:block/yellow_wool");
    private static final int SIDES = 12;
    private static final Vec3 JOLT_UNIT_X = new Vec3(1.0f, 0.0f, 0.0f);
    private static final Vec3 JOLT_UNIT_Y = new Vec3(0.0f, 1.0f, 0.0f);

    @Override
    public void render(RopeSoftBody body, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, int packedLight, VxRenderState renderState) {
        float[] renderVertexData = renderState.vertexData;
        if (renderVertexData == null || renderVertexData.length < 6) {
            return;
        }
        float ropeRadius = body.getSyncData(RopeSoftBody.DATA_ROPE_RADIUS).floatValue();
        if (ropeRadius <= 0.0f) {
            return;
        }
        int numNodes = renderVertexData.length / 3;
        this.renderSmoothRope(renderVertexData, numNodes, ropeRadius, poseStack, (MultiBufferSource)bufferSource, packedLight);
    }

    private void renderSmoothRope(float[] vertexData, int numNodes, float ropeRadius, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        int nodeIdx;
        int i;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.cutoutMipped());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(YELLOW_WOOL_BLOCK_TEXTURE);
        Vec3[][] ringVertices = new Vec3[numNodes][12];
        Vec3[] nodePositions = new Vec3[numNodes];
        Vec3[] directions = new Vec3[numNodes];
        for (i = 0; i < numNodes; ++i) {
            nodePositions[i] = new Vec3(vertexData[i * 3], vertexData[i * 3 + 1], vertexData[i * 3 + 2]);
        }
        for (i = 0; i < numNodes; ++i) {
            Vec3 direction = i == 0 ? Op.minus(nodePositions[1], (Vec3Arg)nodePositions[0]) : (i == numNodes - 1 ? Op.minus(nodePositions[i], (Vec3Arg)nodePositions[i - 1]) : Op.plus((Vec3Arg)Op.minus(nodePositions[i + 1], (Vec3Arg)nodePositions[i]), (Vec3Arg)Op.minus(nodePositions[i], (Vec3Arg)nodePositions[i - 1])));
            if (direction.lengthSq() < 1.0E-12f) {
                direction.set(0.0f, -1.0f, 0.0f);
            }
            directions[i] = direction.normalized();
        }
        Vec3 lastUp = Math.abs(directions[0].dot(JOLT_UNIT_Y)) > 0.99f ? directions[0].cross(JOLT_UNIT_X).normalized() : Op.star((Vec3Arg)directions[0].cross(JOLT_UNIT_Y).normalized(), -1.0f);
        for (nodeIdx = 0; nodeIdx < numNodes; ++nodeIdx) {
            Vec3 direction = directions[nodeIdx];
            if (nodeIdx > 0) {
                lastUp = Op.star((QuatArg)Quat.sFromTo(directions[nodeIdx - 1], direction), (Vec3Arg)lastUp);
            }
            Vec3 right = direction.cross(lastUp).normalized();
            for (int sideIdx = 0; sideIdx < 12; ++sideIdx) {
                float angle = (float)sideIdx * 0.5235988f;
                Vec3 offset = Op.plus((Vec3Arg)Op.star((Vec3Arg)right, (float)Math.cos(angle) * ropeRadius), (Vec3Arg)Op.star((Vec3Arg)lastUp, (float)Math.sin(angle) * ropeRadius));
                ringVertices[nodeIdx][sideIdx] = Op.plus((Vec3Arg)nodePositions[nodeIdx], (Vec3Arg)offset);
            }
        }
        for (nodeIdx = 0; nodeIdx < numNodes - 1; ++nodeIdx) {
            for (int sideIdx = 0; sideIdx < 12; ++sideIdx) {
                int nextSideIdx = (sideIdx + 1) % 12;
                Vec3 v00 = ringVertices[nodeIdx][sideIdx];
                Vec3 v01 = ringVertices[nodeIdx][nextSideIdx];
                Vec3 v10 = ringVertices[nodeIdx + 1][sideIdx];
                Vec3 v11 = ringVertices[nodeIdx + 1][nextSideIdx];
                Vec3 normal = Op.minus(v01, (Vec3Arg)v00).cross(Op.minus(v10, (Vec3Arg)v00)).normalized();
                if (normal.lengthSq() < 1.0E-9f) {
                    normal.set(0.0f, 1.0f, 0.0f);
                }
                this.addQuad(buffer, poseStack, v00, v10, v11, v01, normal, packedLight, sprite);
            }
        }
    }

    private void addQuad(VertexConsumer buffer, PoseStack poseStack, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, Vec3 normal, int packedLight, TextureAtlasSprite sprite) {
        PoseStack.Pose last = poseStack.last();
        buffer.addVertex(last, v1.getX(), v1.getY(), v1.getZ()).setColor(255, 255, 255, 255).setUv(sprite.getU0(), sprite.getV0()).setLight(packedLight).setNormal(last, normal.getX(), normal.getY(), normal.getZ());
        buffer.addVertex(last, v2.getX(), v2.getY(), v2.getZ()).setColor(255, 255, 255, 255).setUv(sprite.getU1(), sprite.getV0()).setLight(packedLight).setNormal(last, normal.getX(), normal.getY(), normal.getZ());
        buffer.addVertex(last, v3.getX(), v3.getY(), v3.getZ()).setColor(255, 255, 255, 255).setUv(sprite.getU1(), sprite.getV1()).setLight(packedLight).setNormal(last, normal.getX(), normal.getY(), normal.getZ());
        buffer.addVertex(last, v4.getX(), v4.getY(), v4.getZ()).setColor(255, 255, 255, 255).setUv(sprite.getU0(), sprite.getV1()).setLight(packedLight).setNormal(last, normal.getX(), normal.getY(), normal.getZ());
    }
}

